/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui;

import com.google.common.base.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILogEventsQueue;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISystemSettings;
import org.eclipse.epp.internal.logging.aeri.ui.utils.NoException;
import org.eclipse.jdt.annotation.Nullable;

public class LogListener
implements ILogListener {
    private static final int MAX_EVENT_QUEUE_SIZE = 40;
    private Predicate<IStatus> statusFilters;
    private IEventBroker broker;
    private ISystemSettings systemSettings;
    private ILogEventsQueue queue;

    @Inject
    public LogListener(@Named(value="org.eclipse.epp.logging.aeri.ui.statusFilters") Predicate<IStatus> statusFilters, ISystemSettings systemSettings, ILogEventsQueue queue, IEventBroker broker) {
        this.statusFilters = statusFilters;
        this.systemSettings = systemSettings;
        this.queue = queue;
        this.broker = broker;
    }

    public void logging(@Nullable IStatus status, @Nullable String plugin) {
        if (status == null) {
            return;
        }
        if (!this.systemSettings.isEnabled()) {
            return;
        }
        int eventQueueSize = this.queue.getGroups().size();
        if (eventQueueSize >= 40) {
            Logs.debug("Event queue limit reached ({0}). Dropping event.", eventQueueSize);
            return;
        }
        if (!this.statusFilters.apply((Object)status)) {
            return;
        }
        if (status.getException() == null) {
            Throwable missing = new NoException().fillInStackTrace();
            status = this.copy(status, missing);
        }
        this.notifyNewStatus(status);
    }

    private IStatus copy(IStatus status, Throwable missing) {
        status = status.isMultiStatus() ? new MultiStatus(status.getPlugin(), status.getCode(), status.getChildren(), status.getMessage(), missing) : new Status(status.getSeverity(), status.getPlugin(), status.getMessage(), missing);
        return status;
    }

    private void notifyNewStatus(IStatus status) {
        this.broker.post("org/eclipse/epp/internal/logging/aeri/ui/status/new", (Object)status);
    }
}

