/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epp.internal.logging.aeri.ui.dialogs.EclipseServerPage;
import org.eclipse.epp.internal.logging.aeri.ui.dialogs.ReviewDialog;
import org.eclipse.epp.internal.logging.aeri.ui.dialogs.ServersPage;
import org.eclipse.epp.internal.logging.aeri.ui.dialogs.SetupWizard;
import org.eclipse.epp.internal.logging.aeri.ui.dialogs.SystemSettingsPage;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ui.model.ILogEventsQueue;
import org.eclipse.epp.internal.logging.aeri.ui.model.IModelFactory;
import org.eclipse.epp.internal.logging.aeri.ui.model.IProblemState;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISendOptions;
import org.eclipse.epp.internal.logging.aeri.ui.model.IServer;
import org.eclipse.epp.internal.logging.aeri.ui.model.ISystemSettings;
import org.eclipse.epp.internal.logging.aeri.ui.model.ProblemStatus;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendMode;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NotificationsService;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Browsers;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Constants;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Formats;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Servers;
import org.eclipse.epp.internal.logging.aeri.ui.utils.SetupWizardDialog;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;

@Singleton
public class EventsController {
    private IEclipseContext context;
    private IEventBroker broker;
    private NotificationsService notifications;
    private ILogEventsQueue queue;
    private ISystemSettings system;
    private List<IServer> servers;
    private boolean systemStateSetupInProgress;
    private boolean systemStateReviewInProgress;
    private boolean systemStateNotificationInProgress;
    private long setupTimeout;
    @Nullable
    private ILogEventGroup delayedGroup;
    @Nullable
    Job uploadJob = null;
    ConcurrentLinkedQueue<ILogEventGroup> uploadQueue = new ConcurrentLinkedQueue();

    @Inject
    public void setConfigureInProgress(@Named(value="org.eclipse.epp.logging.aeri.ui.ui.configure-ongoing") boolean newState) {
        this.systemStateSetupInProgress = newState;
    }

    @Inject
    public void setReviewInProgress(@Named(value="org.eclipse.epp.logging.aeri.ui.ui.review-ongoing") boolean newState) {
        this.systemStateReviewInProgress = newState;
    }

    @Inject
    public void setNotificationInProgress(@Named(value="org.eclipse.epp.logging.aeri.ui.ui.notification-ongoing") boolean newState) {
        this.systemStateSetupInProgress = newState;
    }

    @Inject
    public EventsController(@Named(value="org.eclipse.epp.logging.aeri.ui.servers") List<IServer> endpoints, ILogEventsQueue queue, ISystemSettings settings, IEventBroker broker, NotificationsService notifications, IEclipseContext context) {
        this.servers = endpoints;
        this.queue = queue;
        this.system = settings;
        this.broker = broker;
        this.notifications = notifications;
        this.context = context;
    }

    @Inject
    @Optional
    @VisibleForTesting
    protected void onUserRequestsSetupSystem(@UIEventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/system/setup") Event event) {
        try {
            this.onUserRequestsSetupSystemSafe();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, e);
        }
    }

    private void onUserRequestsSetupSystemSafe() {
        Preconditions.checkState((!this.systemStateSetupInProgress ? 1 : 0) != 0);
        IEclipseContext child = this.context.createChild("setup-wizard");
        ImmutableList<IServer> unconfigured = Servers.copyOfUnconfigured(this.servers);
        child.set("org.eclipse.epp.logging.aeri.ui.servers", unconfigured);
        SetupWizard wizard = (SetupWizard)((Object)ContextInjectionFactory.make(SetupWizard.class, (IEclipseContext)child));
        if (Servers.isOnlyEclipseServer(this.servers)) {
            ISystemSettings system = (ISystemSettings)child.get(ISystemSettings.class);
            IServer eclipseServer = (IServer)Preconditions.checkNotNull((Object)this.servers.get(0));
            wizard.addPage((IWizardPage)new EclipseServerPage(eclipseServer, system));
        } else {
            SystemSettingsPage defaultsPage = (SystemSettingsPage)((Object)ContextInjectionFactory.make(SystemSettingsPage.class, (IEclipseContext)child));
            ServersPage serversPage = (ServersPage)((Object)ContextInjectionFactory.make(ServersPage.class, (IEclipseContext)child));
            wizard.addPage((IWizardPage)defaultsPage);
            wizard.addPage((IWizardPage)serversPage);
        }
        Shell parentShell = (Shell)child.get("activeShell");
        SetupWizardDialog dialog = new SetupWizardDialog(parentShell, (IWizard)wizard){

            protected void finishPressed() {
                super.finishPressed();
                EventsController.this.scheduleDelayedLogEvent();
            }
        };
        dialog.open();
    }

    @Inject
    @Optional
    @VisibleForTesting
    protected void onUserRequestsSetupNewEndpoints(@UIEventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/servers/setup") Event event) {
        try {
            this.onUserRequestsSetupNewEndpointsSafe();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, e);
        }
    }

    private void onUserRequestsSetupNewEndpointsSafe() {
        Preconditions.checkState((!this.systemStateSetupInProgress ? 1 : 0) != 0);
        IEclipseContext child = this.context.createChild("setup-wizard");
        ImmutableList<IServer> unconfigured = Servers.copyOfUnconfigured(this.servers);
        child.set("org.eclipse.epp.logging.aeri.ui.servers", unconfigured);
        SetupWizard wizard = (SetupWizard)((Object)ContextInjectionFactory.make(SetupWizard.class, (IEclipseContext)child));
        ServersPage serversPage = (ServersPage)((Object)ContextInjectionFactory.make(ServersPage.class, (IEclipseContext)child));
        wizard.addPage((IWizardPage)serversPage);
        Shell parentShell = (Shell)child.get("activeShell");
        SetupWizardDialog dialog = new SetupWizardDialog(parentShell, (IWizard)wizard){

            protected void finishPressed() {
                super.finishPressed();
                EventsController.this.scheduleDelayedLogEvent();
            }
        };
        dialog.open();
    }

    private void scheduleDelayedLogEvent() {
        ILogEventGroup local = this.delayedGroup;
        this.delayedGroup = null;
        if (local != null && this.canShowNotification()) {
            this.notifications.showNewEventLogNotification(local);
        }
    }

    @Inject
    @Optional
    @VisibleForTesting
    protected void onUserEnablesSystem(@UIEventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/system/enabled") Event event) {
        try {
            this.onUserEnablesSystemSafe();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, e);
        }
    }

    private void onUserEnablesSystemSafe() {
        this.system.setSendMode(SendMode.NOTIFY);
        this.system.setConfigured(true);
        Logs.log(LogMessages.INFO_AERI_ENABLED);
        EList<ILogEventGroup> groups = this.queue.getGroups();
        if (groups.isEmpty()) {
            return;
        }
        this.scheduleDelayedLogEvent();
    }

    @Inject
    @Optional
    @VisibleForTesting
    protected void onUserDisablesSystem(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/system/disabled") Event event) {
        try {
            this.onUserDisablesSystemSafe();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, e);
        }
    }

    private void onUserDisablesSystemSafe() {
        this.system.setSendMode(SendMode.NEVER);
        this.system.setConfigured(true);
        this.queue.getGroups().clear();
        this.delayedGroup = null;
        Logs.log(LogMessages.INFO_AERI_DISABLED);
    }

    @Inject
    @Optional
    @VisibleForTesting
    protected void onUserDisablesNewEndpoints(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/servers/disabled") Event event) {
        try {
            this.onUserDisablesNewEndpointsSafe();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, e);
        }
    }

    private void onUserDisablesNewEndpointsSafe() {
        this.delayedGroup = null;
        for (IServer server : Servers.viewOfUnconfigured(this.servers)) {
            server.setEnabled(false);
            server.setConfigured(true);
        }
    }

    @Inject
    @Optional
    @VisibleForTesting
    protected void onNewEvent(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/status/new") IStatus status) {
        try {
            this.onNewEventSafe(status);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, e);
        }
    }

    private void onNewEventSafe(IStatus status) {
        LinkedList events = Lists.newLinkedList();
        for (IServer server : Servers.viewOfEnabled(this.servers)) {
            ISendOptions options = Constants.eFac.createSendOptions();
            Servers.copyServerDefaultsIfUnset(server, options);
            Servers.copySystemDefaultsIfUnset(this.system, options);
            IEclipseContext eventContext = this.context.createChild("event-context-for-" + server.getId());
            eventContext.set(IStatus.class, (Object)status);
            eventContext.set(IServer.class, (Object)server);
            eventContext.set(ISendOptions.class, (Object)options);
            IProblemState prediction = this.pollInterest(server, status, eventContext);
            if (!this.isInterested(prediction)) continue;
            ILogEvent event = Constants.eFac.createLogEvent();
            event.setContext(eventContext);
            event.setStatus(status);
            event.setServer(server);
            event.setPredictedProblemState(prediction);
            event.setOptions(options);
            events.add(event);
        }
        if (!events.isEmpty()) {
            ILogEventGroup group = Constants.eFac.createLogEventGroup();
            group.setStatus(status);
            group.getEvents().addAll((Collection)events);
            this.notifyTestNewLogEvents(group);
        }
    }

    private IProblemState pollInterest(IServer server, IStatus status, IEclipseContext eventContext) {
        IProblemState res;
        try {
            res = server.interested(status, eventContext, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Logs.log(LogMessages.WARN_SERVER_FAILURE, e, server.getId(), e.getMessage());
            res = Constants.eFac.createProblemState();
            res.setStatus(ProblemStatus.FAILURE);
            res.setMessage("Endpoint failed with exception: " + e.getMessage());
        }
        eventContext.set(IProblemState.class, (Object)res);
        return res;
    }

    private boolean isInterested(IProblemState predictedState) {
        ProblemStatus status = predictedState.getStatus();
        return !ImmutableSet.of((Object)((Object)ProblemStatus.IGNORED), (Object)((Object)ProblemStatus.INVALID)).contains((Object)status);
    }

    @Inject
    @Optional
    @VisibleForTesting
    protected synchronized void onNewLogGroup(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/event/new") ILogEventGroup group) {
        try {
            this.onNewLogGroupSafe(group);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, e);
        }
    }

    private void onNewLogGroupSafe(ILogEventGroup group) {
        EList<ILogEventGroup> groups = this.queue.getGroups();
        groups.add((Object)group);
        if (!this.system.isConfigured()) {
            if (this.isAfterWelcomeTimeout()) {
                this.setupTimeout = this.in(15, TimeUnit.MINUTES);
                this.notifications.showWelcomeNotification();
                this.delayedGroup = group;
            }
            return;
        }
        LinkedList unconfiguredServers = Lists.newLinkedList();
        for (ILogEvent event : group.getEvents()) {
            IServer server = event.getServer();
            if (server.isConfigured()) continue;
            unconfiguredServers.add(server);
        }
        if (!unconfiguredServers.isEmpty()) {
            if (this.canShowNotification() && this.isAfterWelcomeTimeout()) {
                this.setupTimeout = this.in(15, TimeUnit.MINUTES);
                this.notifications.showNewServersAvailable(unconfiguredServers);
                this.delayedGroup = group;
            }
            return;
        }
        if (this.system.getSendMode() == SendMode.BACKGROUND) {
            groups.remove((Object)group);
            this.broker.post("org/eclipse/epp/internal/logging/aeri/ui/event/send", (Object)group);
        } else if (this.canShowNotification()) {
            this.notifications.showNewEventLogNotification(group);
        }
    }

    private boolean canShowNotification() {
        return !this.systemStateSetupInProgress && !this.systemStateReviewInProgress && !this.systemStateNotificationInProgress;
    }

    private boolean isAfterWelcomeTimeout() {
        return System.currentTimeMillis() > this.setupTimeout;
    }

    private long in(int i, TimeUnit minutes) {
        return System.currentTimeMillis() + minutes.toMillis(i);
    }

    @Inject
    @Optional
    @VisibleForTesting
    protected void onUserRequestsReview(@UIEventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/event/review") ILogEventGroup event) {
        try {
            this.onUserRequestsReviewSafe(event);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, e);
        }
    }

    private void onUserRequestsReviewSafe(ILogEventGroup event) {
        IEclipseContext child = this.context.createChild("review-dialog");
        ImageRegistry imageRegistry = (ImageRegistry)child.get(ImageRegistry.class);
        Preconditions.checkNotNull((Object)imageRegistry);
        child.set(ILogEventGroup.class, (Object)event);
        ReviewDialog dialog = (ReviewDialog)((Object)child.get(ReviewDialog.class));
        dialog.open();
    }

    @Inject
    @Optional
    @VisibleForTesting
    protected void onSendLogEventGroup(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/event/send") ILogEventGroup group) {
        try {
            this.onSendLogEventGroupSafe(group);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, e);
        }
    }

    private void onSendLogEventGroupSafe(ILogEventGroup group) {
        Preconditions.checkNotNull((Object)group);
        this.uploadQueue.add(group);
        if (this.uploadJob != null && this.uploadJob.getState() == 4) {
            return;
        }
        this.uploadJob = new Job("Sending error reports"){

            protected IStatus run(IProgressMonitor monitor) {
                while (!EventsController.this.uploadQueue.isEmpty()) {
                    ILogEventGroup group = EventsController.this.uploadQueue.poll();
                    for (ILogEvent event : group.getEvents()) {
                        IServer server = event.getServer();
                        if (!server.isActive()) {
                            Logs.debug("Skipping report ''{1}'' for not yet enabled endpoint ''{0}''", server.getName(), event.getLabel());
                            continue;
                        }
                        try {
                            IProblemState response = server.send(event.getStatus(), event.getContext(), monitor);
                            event.setResponse(response);
                        }
                        catch (Exception e) {
                            Logs.warn("Sending report to ''{0}'' failed: {1}", e, server.getName(), e.getMessage());
                            IProblemState response = IModelFactory.eINSTANCE.createProblemState();
                            response.setStatus(ProblemStatus.FAILURE);
                            response.setMessage("Sending report failed: " + e.getMessage());
                            response.setMessage(Formats.format("Sending report to ''{0}'' encountered an error: {1}", server.getName(), e.getMessage()));
                            event.setResponse(response);
                        }
                    }
                    if (!EventsController.this.canShowNotification()) continue;
                    EventsController.this.notifications.showServerResponses(group);
                }
                return Status.OK_STATUS;
            }
        };
        this.uploadJob.schedule();
    }

    @Inject
    @Optional
    void onSendLogEventQueue(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/event/send") Event event) {
        try {
            this.onSendLogEventQueueSafe();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, e);
        }
    }

    private void onSendLogEventQueueSafe() {
        EList<ILogEventGroup> groups = this.queue.getGroups();
        ImmutableList events = ImmutableList.copyOf(groups);
        groups.clear();
        for (ILogEventGroup group : events) {
            this.onSendLogEventGroup(group);
        }
    }

    @Inject
    @Optional
    void onClearEventQueue(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/events/clear") Event event) {
        try {
            this.onClearEventQueueSafe();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, e);
        }
    }

    private void onClearEventQueueSafe() {
        EList<ILogEventGroup> events = this.queue.getGroups();
        ImmutableList copy = ImmutableList.copyOf(events);
        events.clear();
        for (ILogEventGroup group : copy) {
            for (ILogEvent logEvent : group.getEvents()) {
                IServer server = logEvent.getServer();
                server.discarded(logEvent.getStatus(), logEvent.getContext());
            }
        }
    }

    @Inject
    @Optional
    @VisibleForTesting
    protected void onOpenBrowser(@UIEventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/event/open-url") String url) {
        if (this.isValidUrl(url)) {
            Browsers.openInExternalBrowser(url);
        }
    }

    private boolean isValidUrl(String url) {
        try {
            URI uri = URI.create(url);
            uri.toURL();
            return true;
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)new LogMessages(2, "Cannot open browser for URL ''{0}'': {1}"), e, url, e.getMessage());
            return false;
        }
    }

    private boolean notifyTestNewLogEvents(ILogEventGroup group) {
        return this.broker.post("org/eclipse/epp/internal/logging/aeri/ui/event/new", (Object)group);
    }
}

