/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.config.core.definition;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.DefinitionContext;
import org.jboss.tools.cdi.internal.core.impl.definition.FieldDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.MethodDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.seam.config.core.CDISeamConfigCorePlugin;
import org.jboss.tools.cdi.seam.config.core.ConfigDefinitionContext;
import org.jboss.tools.cdi.seam.config.core.definition.ConfigFieldDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.ConfigMethodDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.ConfigTypeDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.ConfigVirtualFieldDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SAXNodeProblem;
import org.jboss.tools.cdi.seam.config.core.definition.SeamBeanDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamFieldDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamFieldValueDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamMemberDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamMethodDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamParameterDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamVirtualFieldDefinition;
import org.jboss.tools.cdi.seam.config.core.util.Util;
import org.jboss.tools.cdi.seam.config.core.xml.SAXElement;
import org.jboss.tools.cdi.seam.config.core.xml.SAXNode;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaAnnotation;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ITypeDeclaration;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.java.TypeDeclaration;
import org.jboss.tools.common.model.XModelObject;

public class SeamBeansDefinition {
    IResource resource;
    XModelObject file;
    List<SAXNodeProblem> unresolvedNodes = new ArrayList<SAXNodeProblem>();
    Set<String> possibleTypeNames = new HashSet<String>();
    Set<SeamBeanDefinition> beanDefinitions = new HashSet<SeamBeanDefinition>();
    Set<SeamVirtualFieldDefinition> virtualFieldDefinitions = new HashSet<SeamVirtualFieldDefinition>();
    List<TypeDefinition> typeDefinitions = new ArrayList<TypeDefinition>();
    List<IType> replacedAndModified = new ArrayList<IType>();

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public void setFileObject(XModelObject file) {
        this.file = file;
    }

    public XModelObject getFileObject() {
        return this.file;
    }

    public IResource getResource() {
        return this.resource;
    }

    public List<SAXNodeProblem> getUnresolvedNodes() {
        return this.unresolvedNodes;
    }

    public Set<String> getPossibleTypeNames() {
        return this.possibleTypeNames;
    }

    public void addUnresolvedNode(SAXNodeProblem problem) {
        this.unresolvedNodes.add(problem);
    }

    public void addUnresolvedNode(SAXNode node, String problemId, String message) {
        this.addUnresolvedNode(new SAXNodeProblem(node, problemId, message));
    }

    public void addPossibleTypeNames(Set<String> types) {
        this.possibleTypeNames.addAll(types);
    }

    public void addBeanDefinition(SeamBeanDefinition def) {
        this.beanDefinitions.add(def);
    }

    public Set<SeamBeanDefinition> getBeanDefinitions() {
        return this.beanDefinitions;
    }

    public void addVirtualField(SeamVirtualFieldDefinition def) {
        this.virtualFieldDefinitions.add(def);
    }

    public Set<SeamVirtualFieldDefinition> getVirtualFieldDefinitions() {
        return this.virtualFieldDefinitions;
    }

    public List<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public void buildTypeDefinitions(ConfigDefinitionContext context) {
        TypeDefinition typeDef;
        IType type;
        this.typeDefinitions.clear();
        for (SeamBeanDefinition seamBeanDefinition : this.beanDefinitions) {
            boolean modifies;
            type = seamBeanDefinition.getType();
            typeDef = new ConfigTypeDefinition();
            typeDef.setFileObject(this.file);
            boolean replaces = seamBeanDefinition.getReplacesLocation() != null;
            boolean bl = modifies = seamBeanDefinition.getModifiesLocation() != null;
            if (replaces || modifies) {
                this.replacedAndModified.add(type);
                ((DefinitionContext)context.getRootContext()).veto(type);
            }
            int flags = AbstractMemberDefinition.FLAG_ALL_MEMBERS;
            if (!modifies) {
                flags |= AbstractMemberDefinition.FLAG_NO_ANNOTATIONS;
            }
            typeDef.setType(type, context.getRootContext(), flags);
            seamBeanDefinition.setConfigType((ConfigTypeDefinition)typeDef);
            this.mergeTypeDefinition(seamBeanDefinition, (ConfigTypeDefinition)typeDef, context);
            this.typeDefinitions.add(typeDef);
        }
        for (SeamVirtualFieldDefinition seamVirtualFieldDefinition : this.virtualFieldDefinitions) {
            type = seamVirtualFieldDefinition.getType();
            typeDef = new ConfigVirtualFieldDefinition();
            typeDef.setFileObject(this.file);
            typeDef.setConfig(seamVirtualFieldDefinition);
            int flags = AbstractMemberDefinition.FLAG_NO_ANNOTATIONS;
            typeDef.setType(type, context.getRootContext(), flags);
            this.mergeAnnotations(seamVirtualFieldDefinition, (AbstractMemberDefinition)typeDef, context);
            typeDef.setBeanConstructor(true);
            this.typeDefinitions.add(typeDef);
        }
    }

    public void clean(ConfigDefinitionContext context) {
        List<IType> ds = this.replacedAndModified;
        this.replacedAndModified = new ArrayList<IType>();
        for (IType type : ds) {
            ((DefinitionContext)context.getRootContext()).unveto(type);
        }
    }

    public SeamMemberDefinition findExactly(int offset) {
        for (SeamBeanDefinition b : this.beanDefinitions) {
            SeamMemberDefinition d = b.findExactly(offset);
            if (d == null) continue;
            return d;
        }
        return null;
    }

    private void mergeTypeDefinition(SeamBeanDefinition def, ConfigTypeDefinition typeDef, ConfigDefinitionContext context) {
        typeDef.setConfig(def);
        this.mergeAnnotations(def, (AbstractMemberDefinition)typeDef, context);
        List fieldDefs = typeDef.getFields();
        ArrayList<ConfigFieldDefinition> virtualDefs = new ArrayList<ConfigFieldDefinition>();
        for (FieldDefinition fieldDef : fieldDefs) {
            List ps;
            String n = fieldDef.getField().getElementName();
            SeamFieldDefinition f = def.getField(n);
            if (f == null) continue;
            ParametedType t = null;
            IParametedType collection = null;
            IParametedType map = null;
            ParametedType object = null;
            try {
                String returnType = fieldDef.getField().getTypeSignature();
                t = context.getRootContext().getProject().getTypeFactory().getParametedType((IMember)fieldDef.getField(), returnType);
                object = context.getRootContext().getProject().getTypeFactory().getParametedType((IMember)fieldDef.getField(), "QObject;");
            }
            catch (CoreException e) {
                CDISeamConfigCorePlugin.getDefault().logError(e);
            }
            if (t != null && t.getType() != null) {
                collection = this.getCollection(t);
                map = this.getMap(t);
            }
            List<SeamFieldValueDefinition> vs = f.getValueDefinitions();
            if (collection != null) {
                ps = t.getParameters();
                ParametedType elementType = ps.isEmpty() ? object : (IParametedType)ps.get(0);
                for (SeamFieldValueDefinition v : vs) {
                    ConfigFieldDefinition virtual = new ConfigFieldDefinition(this.file);
                    virtual.setTypeDefinition(fieldDef.getTypeDefinition());
                    virtual.setField(fieldDef.getField(), context.getRootContext(), AbstractMemberDefinition.FLAG_NO_ANNOTATIONS);
                    virtual.setOverridenType((ITypeDeclaration)new TypeDeclaration(elementType, fieldDef.getField().getResource(), 0, 0));
                    virtual.setConfig(v);
                    virtualDefs.add(virtual);
                    v.setRequiredType((IParametedType)elementType);
                    this.mergeAnnotations(v, (AbstractMemberDefinition)virtual, context);
                }
            } else if (map != null) {
                ps = t.getParameters();
                ParametedType keyType = ps.isEmpty() ? object : (IParametedType)ps.get(0);
                ParametedType valueType = ps.size() < 2 ? object : (IParametedType)ps.get(1);
                for (SeamFieldValueDefinition v : vs) {
                    ConfigFieldDefinition virtual = new ConfigFieldDefinition(this.file);
                    virtual.setTypeDefinition(fieldDef.getTypeDefinition());
                    virtual.setField(fieldDef.getField(), context.getRootContext(), AbstractMemberDefinition.FLAG_NO_ANNOTATIONS);
                    ParametedType vType = Util.isKey((SAXElement)v.getNode()) ? keyType : valueType;
                    v.setRequiredType((IParametedType)vType);
                    virtual.setOverridenType((ITypeDeclaration)new TypeDeclaration(vType, fieldDef.getField().getResource(), 0, 0));
                    virtual.setConfig(v);
                    virtualDefs.add(virtual);
                    this.mergeAnnotations(v, (AbstractMemberDefinition)virtual, context);
                }
            } else {
                for (SeamFieldValueDefinition v : vs) {
                    v.setRequiredType((IParametedType)t);
                }
            }
            ((ConfigFieldDefinition)fieldDef).setConfig(f);
            this.mergeAnnotations(f, (AbstractMemberDefinition)fieldDef, context);
            if (vs.isEmpty() || collection != null || map != null) continue;
            this.mergeAnnotations(vs.get(0), (AbstractMemberDefinition)fieldDef, context);
        }
        fieldDefs.addAll(virtualDefs);
        List methodDefs = typeDef.getMethods();
        for (MethodDefinition methodDef : methodDefs) {
            SeamMethodDefinition m;
            IMethod method = methodDef.getMethod();
            if (method == null || (m = def.getMethod(method)) == null) continue;
            ((ConfigMethodDefinition)methodDef).setConfig(m);
            this.mergeAnnotations(m, (AbstractMemberDefinition)methodDef, context);
            List psDefs = methodDef.getParameters();
            List<SeamParameterDefinition> ps = m.getParameters();
            if (ps.size() != psDefs.size()) continue;
            int i = 0;
            while (i < ps.size()) {
                this.mergeAnnotations(ps.get(i), (AbstractMemberDefinition)psDefs.get(i), context);
                ++i;
            }
        }
        typeDef.checkConstructor();
    }

    private void mergeAnnotations(SeamMemberDefinition def, AbstractMemberDefinition memberDef, ConfigDefinitionContext context) {
        Map<String, IJavaAnnotation> annotations = def.getAnnotations();
        for (String typeName : annotations.keySet()) {
            IJavaAnnotation ja = annotations.get(typeName);
            AnnotationDeclaration current = memberDef.getAnnotation(typeName);
            if (current != null) {
                memberDef.removeAnnotation((IAnnotationDeclaration)current);
            }
            memberDef.addAnnotation(ja, context.getRootContext());
        }
    }

    private IParametedType getCollection(ParametedType t) {
        for (IParametedType i : t.getAllTypes()) {
            if (!"java.util.Collection".equals(i.getType().getFullyQualifiedName())) continue;
            return i;
        }
        return null;
    }

    private IParametedType getMap(ParametedType t) {
        for (IParametedType i : t.getAllTypes()) {
            if (!"java.util.Map".equals(i.getType().getFullyQualifiedName())) continue;
            return i;
        }
        return null;
    }
}

