/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.eclipse.util;

import java.lang.reflect.Field;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.WebBrowserEditor;
import org.eclipse.ui.internal.browser.WebBrowserView;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.ui.IServerModule;
import org.jboss.tools.browsersim.eclipse.Activator;

public final class CommandUtil {
    private CommandUtil() {
    }

    public static String guessUrl() {
        String url = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IStructuredSelection ssel;
            Object firstSelectedElement;
            ISelection selection;
            IFile activeEditorFile;
            IWorkbenchPart part;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (url = CommandUtil.getInternalWebBrowserUrl(part = page.getActivePart())) == null && CommandUtil.isSupportedFile(activeEditorFile = CommandUtil.getEditorFile(part))) {
                url = CommandUtil.toUrl(activeEditorFile);
            }
            if (url == null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection && (firstSelectedElement = (ssel = (IStructuredSelection)selection).getFirstElement()) != null) {
                url = CommandUtil.getUrlFromSelection(firstSelectedElement);
            }
        }
        return url;
    }

    private static boolean isSupportedFile(IFile file) {
        if (file != null) {
            IEditorDescriptor[] editors;
            IEditorDescriptor[] iEditorDescriptorArray = editors = PlatformUI.getWorkbench().getEditorRegistry().getEditors(file.getName());
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorDescriptor editor = iEditorDescriptorArray[n2];
                if ("org.jboss.tools.browsersim.eclipse.editors.BrowserSimLauncher".equals(editor.getId())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static String getInternalWebBrowserUrl(IWorkbenchPart part) {
        IEditorPart editorPart;
        IEditorSite editorSite;
        String url = null;
        BrowserViewer browserViewer = null;
        if (part instanceof IViewPart) {
            IViewSite viewSite = ((IViewPart)part).getViewSite();
            if ("org.eclipse.ui.browser.view".equals(viewSite.getId()) && part instanceof WebBrowserView) {
                browserViewer = (BrowserViewer)CommandUtil.getFieldValue(part, "viewer");
            }
        } else if (part instanceof IEditorPart && "org.eclipse.ui.browser.editor".equals((editorSite = (editorPart = (IEditorPart)part).getEditorSite()).getId()) && part instanceof WebBrowserEditor) {
            browserViewer = (BrowserViewer)CommandUtil.getFieldValue(part, "webBrowser");
        }
        if (browserViewer != null) {
            url = browserViewer.getURL();
        }
        return url;
    }

    private static IFile getEditorFile(IWorkbenchPart part) {
        IEditorPart editorPart;
        IFile file = null;
        if (part instanceof IEditorPart && (editorPart = (IEditorPart)part).getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorPart.getEditorInput();
            file = fileEditorInput.getFile();
        }
        return file;
    }

    private static <T> T getFieldValue(Object object, String name) {
        Object fieldValue = null;
        try {
            Field field = object.getClass().getDeclaredField(name);
            field.setAccessible(true);
            fieldValue = field.get(object);
        }
        catch (SecurityException e) {
            Activator.logError(e.getMessage(), e);
        }
        catch (NoSuchFieldException e) {
            Activator.logError(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            Activator.logError(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            Activator.logError(e.getMessage(), e);
        }
        return (T)fieldValue;
    }

    private static IFile getSelectedFile(Object firstSelectedElement) {
        IFile file = null;
        file = (IFile)Platform.getAdapterManager().getAdapter(firstSelectedElement, IFile.class);
        if (file == null && firstSelectedElement instanceof IAdaptable) {
            file = (IFile)((IAdaptable)firstSelectedElement).getAdapter(IFile.class);
        }
        return file;
    }

    private static String getUrlFromSelection(Object firstSelectedElement) {
        IServerModule serverModule;
        String url = null;
        if (firstSelectedElement instanceof IFile) {
            IFile selectedFile = CommandUtil.getSelectedFile(firstSelectedElement);
            if (CommandUtil.isSupportedFile(selectedFile)) {
                url = CommandUtil.toUrl(selectedFile);
            }
        } else if (Platform.getBundle((String)"org.eclipse.wst.server.core") != null && Platform.getBundle((String)"org.eclipse.wst.server.ui") != null && (serverModule = (IServerModule)ResourceUtil.getAdapter((Object)firstSelectedElement, IServerModule.class, (boolean)false)) != null) {
            url = CommandUtil.toUrl(serverModule);
        }
        return url;
    }

    private static String toUrl(IFile file) {
        IPath location;
        String url = null;
        if (file != null && (location = file.getLocation()) != null) {
            url = location.toFile().toURI().toASCIIString();
        }
        return url;
    }

    private static String toUrl(IServerModule serverModule) {
        String url = null;
        IServer server = serverModule.getServer();
        IModule[] module = serverModule.getModule();
        if (server.getServerState() == 2 && module.length == 1) {
            IModule selectedModule = module[0];
            Object serverAdapter = server.loadAdapter(IURLProvider.class, null);
            if (serverAdapter != null && selectedModule != null) {
                URL moduleRootUrl = ((IURLProvider)serverAdapter).getModuleRootURL(selectedModule);
                url = moduleRootUrl.toString();
            }
        }
        return url;
    }
}

