/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.ILaunchConfigConfigurator;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.launch.configuration.JBossLaunchConfigProperties;
import org.jboss.ide.eclipse.as.core.util.ArgsUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.rse.core.RSEFrameworkUtils;
import org.jboss.ide.eclipse.as.rse.core.RSELaunchConfigProperties;
import org.jboss.ide.eclipse.as.rse.core.RSEUtils;

public class RSELaunchConfigurator
implements ILaunchConfigConfigurator {
    private IServer server;

    public RSELaunchConfigurator(IServer server) throws CoreException {
        this.server = server;
    }

    private String getDefaultStopCommand(IServer server) throws CoreException {
        String rseHome = RSEUtils.getRSEHomeDir(server, false);
        String stop = String.valueOf(new Path(rseHome).append("bin").append("shutdown.sh").toString()) + " ";
        JBossServer jbs = (JBossServer)ServerConverter.getJBossServer((IServer)server);
        String args = jbs.getExtendedProperties().getDefaultLaunchArguments().getDefaultStopArgs();
        stop = String.valueOf(stop) + args;
        return stop;
    }

    private String getDefaultLaunchCommand(ILaunchConfiguration config) throws CoreException {
        String serverId = new JBossLaunchConfigProperties().getServerId(config);
        IJBossServer jbossServer = ServerConverter.checkedFindJBossServer((String)serverId);
        String rseHome = jbossServer.getServer().getAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerHomeDir", "");
        String basedir = jbossServer.getServer().getAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerBaseDir", "");
        String currentArgs = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
        String currentVMArgs = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
        if (!"".equals(basedir)) {
            currentArgs = ArgsUtil.setArg((String)currentArgs, null, (String)"-Djboss.server.base.url", (String)basedir);
        }
        String connectionName = RSEUtils.getRSEConnectionName((IServerAttributes)jbossServer.getServer());
        IHost host = RSEFrameworkUtils.findHost(connectionName);
        String remoteSafe = RSEUtils.pathToRemoteSystem(host, rseHome, "server");
        currentArgs = ArgsUtil.setArg((String)currentArgs, null, (String)"-Djboss.server.base.dir", (String)remoteSafe);
        currentArgs = ArgsUtil.setArg((String)currentArgs, null, (String)"--configuration", (String)RSEUtils.getRSEConfigName((IServerAttributes)jbossServer.getServer()));
        currentArgs = ArgsUtil.setArg((String)currentArgs, (String)"-b", null, (String)jbossServer.getServer().getHost());
        currentVMArgs = ArgsUtil.setArg((String)currentVMArgs, null, (String)"-Djava.endorsed.dirs", (String)RSEUtils.pathToRemoteSystem(host, rseHome, "lib/endorsed"), (boolean)true);
        String libPath = new Path(rseHome).append("bin").append("native").toOSString();
        currentVMArgs = ArgsUtil.setArg((String)currentVMArgs, null, (String)"-Djava.library.path", (String)RSEUtils.pathToRemoteSystem(host, libPath, null), (boolean)true);
        String startJar = new Path(rseHome).append("bin").append("run.jar").toString();
        String cmd = "java " + currentVMArgs + " -classpath " + RSEUtils.pathToRemoteSystem(host, startJar, null) + " " + "org.jboss.Main" + " " + currentArgs + "&";
        return cmd;
    }

    public void configure(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        String defaultLaunchCommand = this.getDefaultLaunchCommand((ILaunchConfiguration)launchConfig);
        String defaultStopCommand = this.getDefaultStopCommand(this.server);
        RSELaunchConfigProperties propertyUtil = new RSELaunchConfigProperties();
        propertyUtil.setDefaultStartupCommand(defaultLaunchCommand, launchConfig);
        boolean detectStartupCommand = propertyUtil.isDetectStartupCommand((ILaunchConfiguration)launchConfig, true);
        String currentStartupCmd = propertyUtil.getStartupCommand((ILaunchConfiguration)launchConfig);
        if (detectStartupCommand || !this.isSet(currentStartupCmd)) {
            propertyUtil.setStartupCommand(defaultLaunchCommand, launchConfig);
        }
        propertyUtil.setDefaultShutdownCommand(defaultStopCommand, launchConfig);
        boolean detectShutdownCommand = propertyUtil.isDetectShutdownCommand((ILaunchConfiguration)launchConfig, true);
        String currentStopCmd = propertyUtil.getShutdownCommand((ILaunchConfiguration)launchConfig);
        if (detectShutdownCommand || !this.isSet(currentStopCmd)) {
            propertyUtil.setShutdownCommand(defaultStopCommand, launchConfig);
        }
    }

    private boolean isSet(String value) {
        return value != null;
    }
}

