/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.completions;

import java.util.ArrayList;
import java.util.List;
import tern.ITernProject;
import tern.server.ITernModule;
import tern.server.protocol.completions.FunctionInfo;
import tern.server.protocol.completions.Parameter;
import tern.server.protocol.completions.TernCompletionProposalRec;
import tern.server.protocol.completions.TernTypeHelper;
import tern.utils.StringUtils;

public class TernCompletionItem {
    private final TernCompletionProposalRec proposal;
    private final String displayName;
    private final String signature;
    private final boolean function;
    private boolean array;
    private String jsType;
    private List<Parameter> parameters;
    private String[] allTypes;
    private boolean hasDisplayName;
    private ITernProject ternProject;

    public TernCompletionItem(TernCompletionProposalRec proposal) {
        this.proposal = proposal;
        this.hasDisplayName = !StringUtils.isEmpty(proposal.displayName);
        this.displayName = this.hasDisplayName ? proposal.displayName : proposal.name;
        this.parameters = null;
        String signature = proposal.name;
        this.jsType = proposal.type;
        if (!this.hasDisplayName && !StringUtils.isEmpty(proposal.type)) {
            this.function = TernTypeHelper.isFunction(proposal.type);
            if (this.function) {
                FunctionInfo functionInfo = TernTypeHelper.parseFunction(proposal.name, proposal.type);
                this.parameters = functionInfo.getParameters();
                signature = functionInfo.getSignature();
                this.jsType = functionInfo.getReturnType();
            } else {
                this.array = proposal.type.indexOf("[") != -1;
            }
        } else {
            this.function = false;
            this.array = false;
        }
        this.signature = signature;
    }

    public String[] expand() {
        if (this.allTypes == null) {
            if (this.parameters == null) {
                this.allTypes = StringUtils.EMPTY_ARRAY;
            } else {
                ArrayList<Parameter> optionalParameters = null;
                int i = 0;
                while (i < this.parameters.size()) {
                    Parameter parameter = this.parameters.get(i);
                    if (!parameter.isRequired()) {
                        if (optionalParameters == null) {
                            optionalParameters = new ArrayList<Parameter>();
                        }
                        optionalParameters.add(parameter);
                    }
                    ++i;
                }
                if (optionalParameters == null) {
                    this.allTypes = StringUtils.EMPTY_ARRAY;
                } else {
                    ArrayList<String> types = new ArrayList<String>();
                    int nbMaxOptionalParams = 0;
                    while (nbMaxOptionalParams < optionalParameters.size()) {
                        for (Parameter optional : optionalParameters) {
                            this.addType(types, nbMaxOptionalParams, optional, null);
                        }
                        ++nbMaxOptionalParams;
                    }
                    this.allTypes = types.toArray(StringUtils.EMPTY_ARRAY);
                }
            }
        }
        return this.allTypes;
    }

    public void addType(List<String> types, int nbMaxOptional, Parameter optional, Integer index) {
        Integer newIndex = null;
        int nbOptionalAdded = -1;
        StringBuilder newType = new StringBuilder("fn(");
        int i = 0;
        while (i < this.parameters.size()) {
            Parameter parameter = this.parameters.get(i);
            if (parameter.isRequired()) {
                this.addParam(newType, parameter);
            } else {
                if (nbOptionalAdded == -1 && optional.equals(parameter)) {
                    nbOptionalAdded = 0;
                }
                if (nbOptionalAdded != -1 && nbOptionalAdded < nbMaxOptional) {
                    boolean add = false;
                    if (nbOptionalAdded == 0) {
                        add = true;
                    } else if (index == null) {
                        add = true;
                    } else if (i == index) {
                        add = true;
                    }
                    if (newIndex == null && nbOptionalAdded == 1) {
                        newIndex = this.getNexOptionalIndex(this.parameters, i, index);
                    }
                    if (add) {
                        this.addParam(newType, parameter);
                        ++nbOptionalAdded;
                    }
                }
            }
            ++i;
        }
        newType.append(")");
        if (this.jsType != null) {
            newType.append(" -> ");
            newType.append(this.jsType);
        }
        if (!types.contains(newType.toString())) {
            types.add(newType.toString());
        }
        if (newIndex != null) {
            this.addType(types, nbMaxOptional, optional, newIndex);
        }
    }

    private Integer getNexOptionalIndex(List<Parameter> parameters, int i, Integer index) {
        Parameter parameter = null;
        int j = i + 1;
        while (j < parameters.size()) {
            parameter = parameters.get(j);
            if (!parameter.isRequired() && index == null || index != null && index < j) {
                return j;
            }
            ++j;
        }
        return null;
    }

    public void addParam(StringBuilder newType, Parameter parameter) {
        if (newType.length() > 3) {
            newType.append(", ");
        }
        newType.append(parameter.getName());
        if (!parameter.isRequired()) {
            newType.append("?");
        }
        if (parameter.getType() != null) {
            newType.append(": ");
            newType.append(parameter.getType());
        }
    }

    public String getText() {
        if (StringUtils.isEmpty(this.proposal.origin) && StringUtils.isEmpty(this.jsType)) {
            return this.hasDisplayName ? this.displayName : this.signature;
        }
        StringBuilder text = new StringBuilder(this.hasDisplayName ? this.displayName : this.signature);
        if (!StringUtils.isEmpty(this.jsType)) {
            text.append(" : ");
            text.append(this.jsType);
        }
        if (!StringUtils.isEmpty(this.proposal.origin)) {
            text.append(" - ");
            text.append(this.proposal.origin);
        }
        return text.toString();
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean isFunction() {
        return this.function;
    }

    public boolean isArray() {
        return this.array;
    }

    public String getName() {
        return this.proposal.name;
    }

    public String getDoc() {
        return this.proposal.doc;
    }

    public String getURL() {
        return this.proposal.url;
    }

    public String getOrigin() {
        return this.proposal.origin;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getType() {
        return this.proposal.type;
    }

    public TernCompletionProposalRec getProposal() {
        return this.proposal;
    }

    public String getJsType() {
        return this.jsType;
    }

    public boolean isProperty() {
        return this.proposal.isProperty;
    }

    public boolean isObjectKey() {
        return this.proposal.isObjectKey;
    }

    public boolean hasDisplayName() {
        return this.hasDisplayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isStringType() {
        return "string".equals(this.getType());
    }

    public boolean isStringReturnType() {
        return "string".equals(this.getJsType());
    }

    public ITernProject getTernProject() {
        return this.ternProject;
    }

    public void setTernProject(ITernProject ternProject) {
        this.ternProject = ternProject;
    }

    public ITernModule getTernModule() {
        String origin = this.getOrigin();
        if (origin == null) {
            return null;
        }
        if (this.ternProject == null) {
            return null;
        }
        return this.ternProject.getRepository().getModuleByOrigin(origin);
    }
}

