/*
 * Decompiled with CFR 0.152.
 */
package tern.server;

public class TernModuleInfo {
    private final String name;
    private final String type;
    private final String version;

    public TernModuleInfo(String name) {
        int index = TernModuleInfo.getVersionIndex(name);
        this.name = name;
        if (index != -1) {
            this.type = name.substring(0, index);
            this.version = name.substring(index, name.length());
        } else {
            this.type = name;
            this.version = null;
        }
    }

    public TernModuleInfo(TernModuleInfo info) {
        this.name = info.getName();
        this.type = info.getType();
        this.version = info.getVersion();
    }

    private static int getVersionIndex(String name) {
        char[] chars = name.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (Character.isDigit(chars[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }
}

