/*
 * Decompiled with CFR 0.152.
 */
package tern.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tern.metadata.TernModuleMetadata;
import tern.metadata.TernModuleMetadataManager;
import tern.server.ITernModule;

public class ModuleDependenciesComparator
implements Comparator<ITernModule> {
    private final Map<ITernModule, Integer> modulesMap = new HashMap<ITernModule, Integer>();

    public ModuleDependenciesComparator(List<ITernModule> modules, TernModuleMetadataManager manager) {
        for (ITernModule module : modules) {
            this.updateRelevant(module, modules, this.modulesMap, manager);
        }
        Collections.sort(modules, this);
    }

    private int updateRelevant(ITernModule module, List<ITernModule> modules, Map<ITernModule, Integer> modulesMap, TernModuleMetadataManager manager) {
        Collection<String> dependencies;
        TernModuleMetadata metadata;
        if (modulesMap.containsKey(module)) {
            return modulesMap.get(module);
        }
        int relevant = 1;
        TernModuleMetadata ternModuleMetadata = metadata = manager != null ? manager.getMetadata(module.getType()) : module.getMetadata();
        if (metadata != null && (dependencies = metadata.getDependencies(module.getVersion())) != null) {
            for (String dependency : dependencies) {
                ITernModule dependencyModule = this.getModule(dependency, modules);
                if (dependencyModule == null) continue;
                relevant += this.updateRelevant(dependencyModule, modules, modulesMap, manager);
            }
        }
        modulesMap.put(module, relevant);
        return relevant;
    }

    private ITernModule getModule(String name, List<ITernModule> modules) {
        for (ITernModule module : modules) {
            if (!module.getName().equals(name)) continue;
            return module;
        }
        return null;
    }

    @Override
    public int compare(ITernModule mod1, ITernModule mod2) {
        Integer relevant1 = this.modulesMap.get(mod1);
        Integer relevant2 = this.modulesMap.get(mod2);
        if (relevant1 != null && relevant2 != null) {
            return relevant1 - relevant2;
        }
        return 0;
    }
}

