/*
 * Decompiled with CFR 0.152.
 */
package tern.angular.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tern.angular.modules.Directive;
import tern.angular.modules.DirectiveAndSyntax;
import tern.angular.modules.DirectiveHelper;
import tern.angular.modules.IDirectiveCollector;
import tern.angular.modules.IDirectiveSyntax;
import tern.angular.modules.Module;
import tern.angular.modules.Restriction;

class DirectivesByTagName {
    private final Map<String, DirectiveAndSyntax> directivesMap = new HashMap<String, DirectiveAndSyntax>();
    private final List<Directive> directives = new ArrayList<Directive>();

    public void addDirective(Directive directive) {
        this.directives.add(directive);
        List<String> names = directive.getDirectiveNames();
        int i = 0;
        while (i < names.size()) {
            this.directivesMap.put(names.get(i), new DirectiveAndSyntax(directive, i));
            ++i;
        }
    }

    public void collectDirectives(String directiveName, IDirectiveSyntax syntax, List<Directive> ignoreDirectives, Restriction restriction, IDirectiveCollector collector) {
        String name = null;
        for (Directive directive : this.directives) {
            if (!Module.isMatch(ignoreDirectives, restriction, directive)) continue;
            List<String> names = directive.getDirectiveNames();
            int i = 0;
            while (i < names.size()) {
                if (DirectiveHelper.isSupport(syntax, i) && (name = names.get(i)).startsWith(directiveName)) {
                    collector.add(directive, name);
                }
                ++i;
            }
        }
    }

    public Directive getDirective(String name, Restriction restriction) {
        DirectiveAndSyntax directiveAndSyntax = this.directivesMap.get(name);
        if (directiveAndSyntax != null && directiveAndSyntax.getDirective().isMatch(restriction)) {
            return directiveAndSyntax.getDirective();
        }
        return null;
    }
}

