/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.egit.core;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class GitIgnore {
    public static final String NL = System.getProperty("line.separator");
    private Set<String> entries;
    private IFile file;

    public GitIgnore(IProject project) throws IOException, CoreException {
        this(project.getFile(".gitignore"));
    }

    public GitIgnore(IFile gitIgnoreFile) throws IOException, CoreException {
        this.file = gitIgnoreFile;
        this.initEntries(gitIgnoreFile);
    }

    private void initEntries(IFile gitIgnore) throws IOException, CoreException {
        this.entries = new LinkedHashSet<String>();
        if (gitIgnore == null || !gitIgnore.isAccessible()) {
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(gitIgnore.getContents()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line == null) continue;
                this.entries.add(line);
            }
        }
        catch (Throwable throwable) {
            this.safeClose(reader);
            throw throwable;
        }
        this.safeClose(reader);
    }

    public GitIgnore add(String entry) {
        this.entries.add(entry);
        return this;
    }

    public boolean contains(String entry) {
        return this.entries.contains(entry);
    }

    public int size() {
        return this.entries.size();
    }

    public IFile write(IProgressMonitor monitor) throws CoreException {
        StringBuilder builder = new StringBuilder();
        for (String entry : this.entries) {
            builder.append(entry);
            builder.append(NL);
        }
        if (!this.file.exists()) {
            this.file.create((InputStream)new ByteArrayInputStream(builder.toString().getBytes()), 1, monitor);
        } else {
            this.file.setContents((InputStream)new ByteArrayInputStream(builder.toString().getBytes()), 1, monitor);
        }
        return this.file;
    }

    public boolean exists() {
        return this.file != null && this.file.exists();
    }

    private void safeClose(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
    }
}

