/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.docbook.template;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeElementData;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Node;

public class DocbookTextTemplate
extends VpeAbstractTemplate {
    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        String sourceText = sourceNode.getNodeValue();
        if (sourceText.trim().length() <= 0) {
            return new VpeCreationData((nsIDOMNode)visualDocument.createTextNode(""));
        }
        String visualText = TextUtil.visualText((String)sourceText);
        nsIDOMText visualNewTextNode = visualDocument.createTextNode(visualText);
        nsIDOMElement element = VisualDomUtil.createBorderlessContainer((nsIDOMDocument)visualDocument);
        element.appendChild((nsIDOMNode)visualNewTextNode);
        VpeElementData textElementData = new VpeElementData();
        NodeData nodeData = new NodeData(sourceNode, (nsIDOMNode)visualNewTextNode);
        textElementData.addNodeData(nodeData);
        VpeCreationData result = new VpeCreationData((nsIDOMNode)element);
        result.setElementData(textElementData);
        return result;
    }

    public IRegion getSourceRegionForOpenOn(VpePageContext pageContext, Node sourceNode, nsIDOMNode domNode) {
        Point selection = pageContext.getSourceBuilder().getSelectionRange();
        int offset = TextUtil.getPositionForOpenOn((Node)sourceNode, (VpePageContext)pageContext);
        Region resultRegion = offset >= 0 ? new Region(offset, 0) : new Region(selection.x, 0);
        return resultRegion;
    }
}

