/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib.html;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.html.DynamicAttributeValueProvider;
import org.jboss.tools.jst.web.kb.internal.taglib.html.FileNameAttribute;

public abstract class FileNameAttributeProvider
extends DynamicAttributeValueProvider {
    @Override
    protected CustomTagLibAttribute getAttribute() {
        IFile file = this.context.getResource();
        IProject project = file.getProject();
        HashSet<IResource> ignore = new HashSet<IResource>();
        IResource[] sourceRoots = EclipseUtil.getJavaSourceRoots((IProject)project);
        if (sourceRoots != null && sourceRoots.length > 0) {
            IResource[] iResourceArray = sourceRoots;
            int n = sourceRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                ignore.add(resource);
                ++n2;
            }
            IJavaProject javaProject = EclipseUtil.getJavaProject((IProject)project);
            try {
                IPath path = javaProject.getOutputLocation();
                IResource outputResource = project.getWorkspace().getRoot().findMember(path);
                if (outputResource != null) {
                    ignore.add(outputResource);
                }
            }
            catch (JavaModelException e) {
                WebKbPlugin.getDefault().logError(e);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        IContainer parent = file.getParent();
        if (parent != null) {
            try {
                this.addParent((IResource)file, "", result, ignore);
            }
            catch (CoreException e) {
                WebKbPlugin.getDefault().logError(e);
            }
        }
        FileNameAttribute attribute = null;
        if (!result.isEmpty()) {
            String[] paths = result.toArray(new String[result.size()]);
            attribute = new FileNameAttribute(this.getAttributeName(), "", paths);
        }
        return attribute;
    }

    private void addChildren(IContainer root, String pathToRoot, List<String> result, Set<IResource> ignore) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = root.members(4);
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (!ignore.contains(resource)) {
                if (resource.getType() == 2) {
                    ignore.add(resource);
                    this.addChildren((IContainer)resource, String.valueOf(pathToRoot) + resource.getName() + "/", result, ignore);
                } else if (this.match(resource)) {
                    result.add(String.valueOf(pathToRoot) + resource.getName());
                }
            }
            ++n2;
        }
    }

    private void addParent(IResource child, String pathToRoot, List<String> result, Set<IResource> ignore) throws CoreException {
        IContainer parent = child.getParent();
        if (!(parent == null || parent.getType() != 2 && parent.getType() != 4 || ignore.contains(parent))) {
            ignore.add((IResource)parent);
            this.addChildren(parent, pathToRoot, result, ignore);
            this.addParent((IResource)parent, String.valueOf(pathToRoot) + "../", result, ignore);
        }
    }

    protected abstract String getAttributeName();

    protected abstract boolean match(IResource var1);
}

