/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.KbObject;
import org.jboss.tools.jst.web.kb.internal.scanner.JSF2ResourcesScanner;
import org.jboss.tools.jst.web.kb.internal.taglib.FunctionTagLib;
import org.jboss.tools.jst.web.kb.taglib.IComponent;
import org.jboss.tools.jst.web.kb.taglib.IFaceletTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.w3c.dom.Element;

public class FaceletTagLibrary
extends FunctionTagLib
implements IFaceletTagLibrary {
    public static final String COMPOSITE_LIBRARY_NAME = "composite-library-name";
    protected String compositeLibraryName = null;
    protected Map<Object, Cloned> copies = new Hashtable<Object, Cloned>();
    private static final ITagLibrary[] EMPTY_LIB_ARRAY = new ITagLibrary[0];

    @Override
    public FaceletTagLibrary clone() throws CloneNotSupportedException {
        FaceletTagLibrary copy = (FaceletTagLibrary)super.clone();
        copy.compositeLibraryName = this.compositeLibraryName;
        return copy;
    }

    @Override
    public String getXMLClass() {
        return "facelet";
    }

    public String getCompositeLibraryName() {
        return this.compositeLibraryName;
    }

    public void setCompositeLibraryName(String s) {
        this.compositeLibraryName = s;
    }

    public ITagLibrary[] getCompositeLibraries() {
        IKbProject kbProject = this.getKbProject();
        if (kbProject != null && this.compositeLibraryName != null && this.compositeLibraryName.length() > 0) {
            String uri1 = String.valueOf(JSF2ResourcesScanner.URI_PREFIX) + "/" + this.compositeLibraryName;
            ITagLibrary[] list1 = kbProject.getTagLibraries(uri1);
            String uri2 = String.valueOf(JSF2ResourcesScanner.URI_PREFIX_22) + "/" + this.compositeLibraryName;
            ITagLibrary[] list2 = kbProject.getTagLibraries(uri2);
            if (list1.length == 0) {
                return list2;
            }
            if (list2.length == 0) {
                return list1;
            }
            ITagLibrary[] result = new ITagLibrary[list1.length + list2.length];
            System.arraycopy(list1, 0, result, 0, list1.length);
            System.arraycopy(list2, 0, result, list1.length, list2.length);
            return result;
        }
        return EMPTY_LIB_ARRAY;
    }

    public void setCompositeLibraryName(IValueInfo s) {
        this.compositeLibraryName = s == null ? null : s.getValue();
        this.attributesInfo.put(COMPOSITE_LIBRARY_NAME, s);
    }

    public synchronized void onCompositeLibraryChanged() {
        this.disposeCopies();
    }

    synchronized void disposeCopies() {
        for (Cloned c : this.copies.values()) {
            if (!(c.copy instanceof KbObject)) continue;
            ((KbObject)((Object)c.copy)).dispose();
        }
        this.copies.clear();
    }

    @Override
    public IComponent getComponent(String name) {
        IComponent result = super.getComponent(name);
        if (result == null) {
            ITagLibrary[] ls = this.getCompositeLibraries();
            int i = 0;
            while (result == null && i < ls.length) {
                result = ls[i].getComponent(name);
                if (result != null) {
                    result = this.copy(result);
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public IComponent[] getComponents() {
        IComponent[] result = super.getComponents();
        ITagLibrary[] ls = this.getCompositeLibraries();
        if (ls.length > 0) {
            result = this.union(result, this.collectComponents(ls));
        }
        return result;
    }

    private IComponent[] collectComponents(ITagLibrary[] ls) {
        if (ls.length == 0) {
            return EMPTY_ARRAY;
        }
        ArrayList<IComponent> cs = new ArrayList<IComponent>();
        ITagLibrary[] iTagLibraryArray = ls;
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            IComponent[] cs2;
            ITagLibrary l = iTagLibraryArray[n2];
            IComponent[] iComponentArray = cs2 = l.getComponents();
            int n3 = cs2.length;
            int n4 = 0;
            while (n4 < n3) {
                IComponent c = iComponentArray[n4];
                cs.add(c);
                ++n4;
            }
            ++n2;
        }
        return cs.toArray(new IComponent[0]);
    }

    private void copy(IComponent[] cs2) {
        int i = 0;
        while (i < cs2.length) {
            cs2[i] = this.copy(cs2[i]);
            ++i;
        }
    }

    private synchronized IComponent copy(IComponent c) {
        Cloned cl = this.copies.get(((KbObject)((Object)c)).getId());
        if (cl == null) {
            cl = new Cloned(c);
            this.copies.put(((KbObject)((Object)c)).getId(), cl);
        }
        if (cl.origin != c) {
            cl.setObject(c);
        }
        return cl.copy;
    }

    private IComponent[] union(IComponent[] cs1, IComponent[] cs2) {
        this.copy(cs2);
        if (cs1.length == 0) {
            return cs2;
        }
        if (cs2.length == 0) {
            return cs1;
        }
        IComponent[] res = new IComponent[cs1.length + cs2.length];
        System.arraycopy(cs1, 0, res, 0, cs1.length);
        System.arraycopy(cs2, 0, res, cs1.length, cs2.length);
        return res;
    }

    @Override
    public List<Change> merge(KbObject s) {
        List changes = super.merge(s);
        FaceletTagLibrary library = (FaceletTagLibrary)s;
        if (!this.stringsEqual(this.compositeLibraryName, library.compositeLibraryName)) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, COMPOSITE_LIBRARY_NAME, (Object)this.compositeLibraryName, (Object)library.compositeLibraryName));
            this.compositeLibraryName = library.compositeLibraryName;
            this.disposeCopies();
        }
        return changes;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        super.loadXML(element, context);
        this.setCompositeLibraryName((IValueInfo)this.attributesInfo.get(COMPOSITE_LIBRARY_NAME));
    }

    @Override
    public void dispose() {
        this.disposeCopies();
        super.dispose();
    }

    class Cloned {
        IComponent origin;
        IComponent copy;

        public Cloned(IComponent origin) {
            this.setObject(origin);
        }

        public void setObject(IComponent origin) {
            this.origin = origin;
            try {
                this.copy = (IComponent)((Object)((KbObject)((Object)origin)).clone());
                ((KbObject)((Object)this.copy)).setParent(FaceletTagLibrary.this);
            }
            catch (CloneNotSupportedException e) {
                WebKbPlugin.getDefault().logError(e);
                this.copy = origin;
            }
        }
    }
}

