/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.scanner;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.jst.web.kb.KbMessages;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.internal.KbBuilderMarker;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.jst.web.kb.preferences.KBSeverityPreferences;

public class UsedJavaProjectCheck {
    public void check(KbProject project) throws CoreException {
        block4: {
            IMarker[] ms;
            List<IProject> list;
            block3: {
                if (!project.getProject().isAccessible()) {
                    return;
                }
                list = this.getNonKbJavaProjects(project.getProject());
                ms = KbBuilderMarker.getOwnedMarkers((IResource)project.getProject(), 2);
                String s = KBSeverityPreferences.getInstance().getProjectPreference(project.getProject(), "org.jboss.tools.common.validator.enableBlock");
                if (!list.isEmpty() && !"disabled".equals(s)) break block3;
                if (ms == null) break block4;
                IMarker[] iMarkerArray = ms;
                int n = ms.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker m = iMarkerArray[n2];
                    m.delete();
                    ++n2;
                }
                break block4;
            }
            IMarker m = ms == null ? null : ms[0];
            String projectList = this.asText(list);
            String messageId = list.size() == 1 ? KbMessages.KBPROBLEM_DEPENDS_ON_JAVA_SINGLE : KbMessages.KBPROBLEM_DEPENDS_ON_JAVA_MANY;
            String message = MessageFormat.format(messageId, projectList);
            m = KbBuilderMarker.createOrUpdateKbProblemMarker(m, (IResource)project.getProject(), message, 2);
            for (IProject p : list) {
                if (!p.isAccessible()) continue;
                p.setPersistentProperty(KbProjectFactory.NATURE_MOCK, "true");
            }
        }
    }

    public String asText(List<IProject> list) {
        StringBuffer projectList = new StringBuffer();
        for (IProject p : list) {
            if (projectList.length() > 0) {
                projectList.append(", ");
            }
            projectList.append(p.getName());
        }
        return projectList.toString();
    }

    public List<IProject> getNonKbJavaProjects(IProject project) throws CoreException {
        ArrayList<IProject> list = new ArrayList<IProject>();
        if (!project.hasNature("org.jboss.tools.jst.web.kb.kbnature")) {
            return list;
        }
        if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                IProject p;
                if (es[i].getEntryKind() == 2 && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(es[i].getPath().lastSegment())) != null && p.isAccessible() && p.hasNature("org.eclipse.jdt.core.javanature") && !p.hasNature("org.jboss.tools.jst.web.kb.kbnature")) {
                    list.add(p);
                }
                ++i;
            }
        }
        return list;
    }
}

