/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.kb.internal.LibraryStorage;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.scanner.XMLScanner;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.kb.taglib.TagLibraryManager;

public class StaticLibraries {
    static StaticLibraries instance = new StaticLibraries();
    LibraryStorage libraries = new LibraryStorage();
    Map<File, XModelObject> loadedFolders = new HashMap<File, XModelObject>();
    Map<File, XModelObject> loadedFiles = new HashMap<File, XModelObject>();

    private StaticLibraries() {
    }

    public ITagLibrary[] getLibraries(String uri) {
        File file = TagLibraryManager.getStaticTLD(uri);
        if (file == null) {
            return new ITagLibrary[0];
        }
        if (this.loadedFiles.containsKey(file)) {
            return this.libraries.getLibrariesArray(uri);
        }
        this.addLib(file);
        return this.libraries.getLibrariesArray(uri);
    }

    private void addLib(File file) {
        XModelObject o;
        File folder = file.getParentFile();
        if (!this.loadedFolders.containsKey(folder) && (o = EclipseResourceUtil.createObjectForLocation((String)file.getAbsolutePath())) != null) {
            this.loadedFolders.put(folder, o.getParent());
        }
        if ((o = this.loadedFolders.get(folder)) != null) {
            XModelObject fo = o.getChildByPath(file.getName());
            if (fo == null && o instanceof FolderImpl) {
                ((FolderImpl)o).update();
                fo = o.getChildByPath(file.getName());
            }
            if (fo != null) {
                this.loadedFiles.put(file, fo);
                XMLScanner scanner = new XMLScanner();
                LoadedDeclarations ds = scanner.parse(fo, (IPath)new Path(file.getAbsolutePath()), null);
                List<ITagLibrary> ls = ds.getLibraries();
                for (ITagLibrary l : ls) {
                    this.libraries.addLibrary(l, (IPath)new Path(file.getAbsolutePath()));
                }
            }
        }
    }

    public List<ITagLibrary> getAllTagLibraries() {
        ArrayList<ITagLibrary> libs = new ArrayList<ITagLibrary>();
        List<File> files = TagLibraryManager.getStaticTagLibs();
        for (File file : files) {
            if (!this.loadedFiles.containsKey(file)) {
                this.addLib(file);
            }
            Set<ITagLibrary> ls = this.libraries.getLibrariesBySource((IPath)new Path(file.getAbsolutePath()));
            libs.addAll(ls);
        }
        return libs;
    }
}

