/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.model.project.ext.store.XMLStoreHelper;
import org.w3c.dom.Element;

public class KbObject
implements Cloneable {
    protected Object id;
    protected IPath source;
    protected IResource resource = null;
    protected KbObject parent;
    protected Map<String, IValueInfo> attributesInfo = new HashMap<String, IValueInfo>(8);

    public IKbProject getKbProject() {
        return this.parent == null ? null : this.parent.getKbProject();
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public void setSourcePath(IPath path) {
        this.source = path;
    }

    public IPath getSourcePath() {
        if (this.source == null && this.parent != null) {
            return this.parent.getSourcePath();
        }
        return this.source;
    }

    public IResource getResource() {
        if (this.resource != null) {
            return this.resource;
        }
        if (this.resource == null && this.id instanceof IAdaptable) {
            IResource r;
            this.resource = r = (IResource)((IAdaptable)this.id).getAdapter(IResource.class);
            if (this.resource != null) {
                this.source = this.resource.getFullPath();
            }
        }
        if (this.source != null) {
            this.resource = ResourcesPlugin.getWorkspace().getRoot().getFile(this.source);
        }
        if (this.resource == null && this.parent != null) {
            return this.parent.getResource();
        }
        return this.resource;
    }

    public KbObject getParent() {
        return this.parent;
    }

    public void setParent(KbObject parent) {
        this.parent = parent;
    }

    protected void adopt(KbObject child) {
        if (child.getKbProject() != null && child.getKbProject() != this.getKbProject()) {
            return;
        }
        child.setParent(this);
    }

    public List<Change> merge(KbObject s) {
        KbObject o = s;
        this.source = o.source;
        this.id = o.id;
        this.resource = o.resource;
        o.attributesInfo = new HashMap<String, IValueInfo>();
        o.attributesInfo.putAll(this.attributesInfo);
        return null;
    }

    public KbObject clone() throws CloneNotSupportedException {
        KbObject c = (KbObject)super.clone();
        c.parent = null;
        return c;
    }

    public String getXMLName() {
        return "object";
    }

    public String getXMLClass() {
        return null;
    }

    public Element toXML(Element parent, Properties context) {
        Element element = XMLUtilities.createElement((Element)parent, (String)this.getXMLName());
        if (this.getXMLClass() != null) {
            element.setAttribute("class", this.getXMLClass());
        }
        if (this.source != null && !this.source.equals(context.get("path"))) {
            element.setAttribute("path", this.source.toString());
        }
        if (this.id != null) {
            if (this.id instanceof String) {
                Element eid = XMLUtilities.createElement((Element)element, (String)"id");
                eid.setAttribute("class", "string");
                eid.setAttribute("value", this.id.toString());
            } else if (this.id instanceof XModelObject) {
                XModelObject o = (XModelObject)this.id;
                XMLStoreHelper.saveModelObject((Element)element, (XModelObject)o, (String)"id", (Properties)context);
            }
        }
        XModelObject old = this.pushModelObject(context);
        this.saveAttributesInfo(element, context);
        this.popModelObject(context, old);
        return element;
    }

    protected void saveAttributesInfo(Element element, Properties context) {
        XMLStoreHelper.saveMap((Element)element, this.attributesInfo, (String)"attributes", (Properties)context);
    }

    public void loadXML(Element element, Properties context) {
        String s = element.getAttribute("path");
        this.source = s != null && s.length() > 0 ? new Path(s) : (IPath)context.get("path");
        Element e_id = XMLUtilities.getUniqueChild((Element)element, (String)"id");
        if (e_id != null) {
            String cls = e_id.getAttribute("class");
            if ("string".equals(cls)) {
                this.id = e_id.getAttribute("value");
            } else if ("model-object".equals(cls)) {
                this.id = XMLStoreHelper.loadModelObject((Element)e_id, (Properties)context);
            }
        }
        XModelObject old = this.pushModelObject(context);
        this.loadAttributesInfo(element, context);
        this.popModelObject(context, old);
    }

    protected void loadAttributesInfo(Element element, Properties context) {
        XMLStoreHelper.loadMap((Element)element, this.attributesInfo, (String)"attributes", (Properties)context);
    }

    protected XModelObject pushModelObject(Properties context) {
        XModelObject old = (XModelObject)context.get("model-object");
        if (this.id instanceof XModelObject) {
            context.put("model-object", this.id);
        }
        return old;
    }

    protected void popModelObject(Properties context, XModelObject old) {
        if (old != null) {
            context.put("model-object", old);
        } else {
            context.remove("model-object");
        }
    }

    protected boolean stringsEqual(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public Object getAdapter(Class cls) {
        return null;
    }

    public void dispose() {
        this.attributesInfo.clear();
    }
}

