/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.IProposalProcessor;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.WebKbPlugin;

public class CustomProposalProcessorManager {
    private static final CustomProposalProcessorManager INSTANCE = new CustomProposalProcessorManager();
    private Set<IProposalProcessor> processors;

    private CustomProposalProcessorManager() {
    }

    public static CustomProposalProcessorManager getInstance() {
        return INSTANCE;
    }

    private void init() {
        if (this.processors == null) {
            this.processors = new HashSet<IProposalProcessor>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.jboss.tools.jst.web.kb.proposalProcessor");
            if (extensionPoint != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] elements;
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        String className = element.getAttribute("class");
                        if (className != null) {
                            try {
                                Object obj = element.createExecutableExtension("class");
                                if (obj instanceof IProposalProcessor) {
                                    this.processors.add((IProposalProcessor)obj);
                                } else {
                                    WebKbPlugin.getDefault().logError("Custom Proposal Processor (class name: " + className + ", contributer: " + element.getContributor().getName() + ") must implement " + IProposalProcessor.class.getName());
                                }
                            }
                            catch (CoreException e) {
                                WebKbPlugin.getDefault().logError(e);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
    }

    public List<TextProposal> getProposals(KbQuery query, IPageContext context) {
        this.init();
        ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
        for (IProposalProcessor processor : this.processors) {
            TextProposal[] prProposals;
            TextProposal[] textProposalArray = prProposals = processor.getProposals(query, context);
            int n = prProposals.length;
            int n2 = 0;
            while (n2 < n) {
                TextProposal proposal = textProposalArray[n2];
                proposals.add(proposal);
                ++n2;
            }
        }
        return proposals;
    }
}

