/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.util.EclipseJavaUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.IKbProjectExtension;
import org.w3c.dom.Element;

public abstract class AbstractKbProjectExtension
implements IKbProjectExtension {
    protected IProject project = null;
    protected boolean isBuilt = false;
    protected boolean isStorageResolved = false;
    protected Set<IKbProjectExtension> dependsOn = new HashSet<IKbProjectExtension>();
    protected Set<IKbProjectExtension> usedBy = new HashSet<IKbProjectExtension>();

    @Override
    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public Set<IKbProjectExtension> getDependentProjects() {
        return this.usedBy;
    }

    @Override
    public Set<IKbProjectExtension> getUsedProjects() {
        return this.dependsOn;
    }

    public synchronized boolean dependsOnOtherProjects() {
        return !this.dependsOn.isEmpty();
    }

    public Set<IKbProjectExtension> getUsedProjects(boolean hierarchy) {
        if (hierarchy) {
            if (this.dependsOn.isEmpty()) {
                return this.dependsOn;
            }
            HashSet<IKbProjectExtension> result = new HashSet<IKbProjectExtension>();
            this.getAllUsedProjects(result);
            return result;
        }
        return this.dependsOn;
    }

    void getAllUsedProjects(Set<IKbProjectExtension> result) {
        for (IKbProjectExtension n : this.dependsOn) {
            if (result.contains(n)) continue;
            result.add(n);
            ((AbstractKbProjectExtension)n).getAllUsedProjects(result);
        }
    }

    @Override
    public void addUsedProject(IKbProjectExtension project) {
        if (this.dependsOn.contains(project)) {
            return;
        }
        this.addUsedProjectInternal(project);
        project.addDependentProject(this);
        if (!project.isStorageResolved()) {
            this.resolveUsedProjectInJob(project);
        }
    }

    protected void resolveUsedProjectInJob(IKbProjectExtension project) {
    }

    protected synchronized void addUsedProjectInternal(IKbProjectExtension project) {
        this.dependsOn.add(project);
    }

    @Override
    public void addDependentProject(IKbProjectExtension project) {
        this.usedBy.add(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUsedProject(IKbProjectExtension project) {
        AbstractKbProjectExtension p = (AbstractKbProjectExtension)project;
        if (!this.dependsOn.contains(p)) {
            return;
        }
        p.usedBy.remove(this);
        AbstractKbProjectExtension abstractKbProjectExtension = this;
        synchronized (abstractKbProjectExtension) {
            this.dependsOn.remove(p);
        }
    }

    public IType getType(String qualifiedName) {
        IJavaProject jp = EclipseUtil.getJavaProject((IProject)this.getProject());
        if (jp == null) {
            return null;
        }
        try {
            return EclipseJavaUtil.findType((IJavaProject)jp, (String)qualifiedName);
        }
        catch (JavaModelException e) {
            WebKbPlugin.getDefault().logError(e);
            return null;
        }
    }

    @Override
    public boolean isStorageResolved() {
        return this.isStorageResolved;
    }

    @Override
    public void resolve() {
        this.resolveStorage(true);
    }

    public void resolveStorage(boolean load) {
        if (this.isStorageResolved) {
            return;
        }
        if (load) {
            this.load();
        } else {
            this.isStorageResolved = true;
        }
    }

    public void load() {
        if (this.isStorageResolved) {
            return;
        }
        this.isStorageResolved = true;
        this.build();
        this.postponeFiring();
        try {
            this.loadProjectDependenciesFromKBProject();
        }
        finally {
            this.fireChanges();
        }
    }

    protected abstract void build();

    public void postponeFiring() {
    }

    public void fireChanges() {
    }

    @Override
    public abstract void update(boolean var1);

    public void reloadProjectDependencies() {
        this.dependsOn.clear();
        this.usedBy.clear();
        this.loadProjectDependenciesFromKBProject();
    }

    protected void loadProjectDependenciesFromKBProject() {
        Element root = null;
        File file = this.getKBStorageFile();
        if (file != null && file.isFile() && (root = XMLUtilities.getElement((File)file, null)) != null) {
            this.loadProjectDependencies(root);
        }
    }

    private File getKBStorageFile() {
        IPath path = WebKbPlugin.getDefault().getStateLocation();
        File file = new File(path.toFile(), "projects/" + this.project.getName() + ".xml");
        return file;
    }

    private void loadProjectDependencies(Element root) {
        Element usedElement;
        Element dependsOnElement = XMLUtilities.getUniqueChild((Element)root, (String)"depends-on-projects");
        if (dependsOnElement != null) {
            Element[] paths = XMLUtilities.getChildren((Element)dependsOnElement, (String)"project");
            int i = 0;
            while (i < paths.length) {
                IKbProjectExtension sp;
                IProject project;
                String p = paths[i].getAttribute("name");
                if (p != null && p.trim().length() != 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p)) != null && project.isAccessible() && (sp = this.loadWithFactory(project, false)) != null) {
                    this.addUsedProjectInternal(sp);
                    sp.addDependentProject(this);
                }
                ++i;
            }
        }
        if ((usedElement = XMLUtilities.getUniqueChild((Element)root, (String)"used-by-projects")) != null) {
            Element[] paths = XMLUtilities.getChildren((Element)usedElement, (String)"project");
            int i = 0;
            while (i < paths.length) {
                IKbProjectExtension sp;
                IProject project;
                String p = paths[i].getAttribute("name");
                if (p != null && p.trim().length() != 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p)) != null && project.isAccessible() && (sp = this.loadWithFactory(project, false)) != null) {
                    this.addDependentProject(sp);
                }
                ++i;
            }
        }
    }

    protected abstract IKbProjectExtension loadWithFactory(IProject var1, boolean var2);

    public void dispose() {
    }
}

