/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.log.BaseUIPlugin;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.internal.KbBuilder;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.jst.web.kb.internal.RemoteFileManager;
import org.osgi.framework.BundleContext;

public class WebKbPlugin
extends BaseUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.jst.web.kb";
    public static final String CA_KB_IMAGE_PATH = "icons/ca/el.gif";
    private static WebKbPlugin plugin;
    IResourceChangeListener resourceChangeListener = new RCL();

    public WebKbPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        final RemoteFileManager remoteFileManager = RemoteFileManager.getInstance();
        ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant(PLUGIN_ID, new ISaveParticipant(){

            public void saving(ISaveContext context) throws CoreException {
                switch (context.getKind()) {
                    case 1: 
                    case 2: {
                        IProject[] ps;
                        IProject[] iProjectArray = ps = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int n = ps.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject p = iProjectArray[n2];
                            KbProject sp = (KbProject)KbProjectFactory.getKbProject(p, false, true);
                            if (sp != null && sp.getModificationsSinceLastStore() > 0) {
                                try {
                                    sp.store();
                                }
                                catch (IOException e) {
                                    WebKbPlugin.getDefault().logError(e);
                                }
                            }
                            ++n2;
                        }
                        remoteFileManager.savingState(context);
                        break;
                    }
                    case 3: {
                        KbProject sp = (KbProject)KbProjectFactory.getKbProject(context.getProject(), false, true);
                        try {
                            if (sp == null || sp.getModificationsSinceLastStore() <= 0) break;
                            sp.store();
                            break;
                        }
                        catch (IOException e) {
                            WebKbPlugin.getDefault().logError(e);
                        }
                    }
                }
                WebKbPlugin.this.cleanObsoleteFiles();
            }

            public void rollback(ISaveContext context) {
                remoteFileManager.rollback(context);
            }

            public void prepareToSave(ISaveContext context) throws CoreException {
            }

            public void doneSaving(ISaveContext context) {
                remoteFileManager.doneSaving(context);
            }
        });
        remoteFileManager.setLastSavedState(lastState);
    }

    private void cleanObsoleteFiles() {
        IProject[] ps = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<String> projectNames = new HashSet<String>();
        IProject[] iProjectArray = ps;
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            projectNames.add(p.getName());
            ++n2;
        }
        WebKbPlugin plugin = WebKbPlugin.getDefault();
        if (plugin != null) {
            IPath path = plugin.getStateLocation();
            File file = new File(path.toFile(), "projects");
            if (!file.isDirectory()) {
                return;
            }
            File[] fs = file.listFiles();
            if (fs != null) {
                File[] fileArray = fs;
                int n3 = fs.length;
                int n4 = 0;
                while (n4 < n3) {
                    File f = fileArray[n4];
                    String name = f.getName();
                    if (name.endsWith(".xml") && !projectNames.contains(name = name.substring(0, name.length() - 4))) {
                        f.delete();
                    }
                    ++n4;
                }
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.stop(context);
    }

    public static WebKbPlugin getDefault() {
        return plugin;
    }

    public static void enableKB(IProject project, IProgressMonitor monitor) {
        try {
            WebModelPlugin.addNatureToProjectWithValidationSupport((IProject)project, (String)KbBuilder.BUILDER_ID, (String)"org.jboss.tools.jst.web.kb.kbnature");
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
        }
    }

    public static void disableKB(IProject project) {
        try {
            EclipseUtil.removeNatureFromProject((IProject)project, (String)"org.jboss.tools.jst.web.kb.kbnature");
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
        }
    }

    public static ImageDescriptor getImageDescriptor(Class<?> baseClass, String imageName) {
        return ImageDescriptor.createFromFile(baseClass, (String)imageName);
    }

    public static Image getImage(Class<?> baseClass, String imageName) {
        ImageRegistry registry = WebKbPlugin.getDefault().getImageRegistry();
        Image result = registry.get(imageName);
        if ((result == null || result.isDisposed()) && (result = ImageDescriptor.createFromFile(baseClass, (String)imageName).createImage()) != null) {
            registry.put(imageName, result);
        }
        return result;
    }

    class RCL
    implements IResourceChangeListener {
        RCL() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 4 || event.getType() == 2) {
                KbProject n;
                IResource r = event.getResource();
                if (r instanceof IProject && (n = (KbProject)KbProjectFactory.getKbProject((IProject)r, false, true)) != null) {
                    n.dispose();
                }
            } else if (event.getType() == 1) {
                IResourceDelta[] cs;
                IResourceDelta[] iResourceDeltaArray = cs = event.getDelta().getAffectedChildren(4);
                int n = cs.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta c = iResourceDeltaArray[n2];
                    if ((c.getFlags() & 0x4000) != 0 && c.getResource() instanceof IProject) {
                        IProject p = (IProject)c.getResource();
                        KbProjectFactory.getKbProject(p, true, true);
                    }
                    ++n2;
                }
            }
        }
    }
}

