/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.core.international;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipant2Feature;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipantFeature;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.scanner.FileSet;
import org.jboss.tools.cdi.seam.core.international.CDISeamInternationalDefinitionContext;
import org.jboss.tools.cdi.seam.core.international.impl.BundleModel;
import org.jboss.tools.cdi.seam.core.international.scanner.BundleFileSet;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class CDISeamInternationalExtension
implements ICDIExtension,
IBuildParticipant2Feature {
    CDISeamInternationalDefinitionContext context = new CDISeamInternationalDefinitionContext();
    BundleFileSet fileSet = new BundleFileSet();
    BundleModel model = new BundleModel();

    public static CDISeamInternationalExtension getExtension(CDICoreNature project) {
        Set es = project.getExtensionManager().getExtensions(IBuildParticipantFeature.class);
        for (ICDIExtension ext : es) {
            if (!(ext instanceof CDISeamInternationalExtension)) continue;
            return (CDISeamInternationalExtension)ext;
        }
        return null;
    }

    public BundleModel getBundleModel() {
        return this.model;
    }

    public CDISeamInternationalDefinitionContext getContext() {
        return this.context;
    }

    public void beginVisiting() {
        this.fileSet = new BundleFileSet();
    }

    public void visit(IFile file, IPath src, IPath webinf) {
        IPath path = file.getFullPath();
        if (src != null && src.isPrefixOf(path)) {
            this.addBundle(file, this.fileSet);
        }
    }

    private void addBundle(IFile f, BundleFileSet fileSet) {
        XModelObject b;
        if (f.getName().endsWith(".properties") && (b = this.getObject(f)) != null) {
            fileSet.setBundle(f.getFullPath(), b);
        }
    }

    private XModelObject getObject(IFile f) {
        XModelObject o = EclipseResourceUtil.getObjectByResource((IResource)f);
        if (o == null) {
            o = EclipseResourceUtil.createObjectForResource((IResource)f);
        }
        return o;
    }

    public void visitJar(IPath path, IPackageFragmentRoot root, XModelObject beansXML) {
    }

    public void buildDefinitions() {
        ((CDISeamInternationalDefinitionContext)this.context.getWorkingCopy()).addDefinitions(this.fileSet);
    }

    public void buildDefinitions(FileSet fileSet) {
    }

    public void buildBeans(CDIProject target) {
        this.model.rebuild(this.context.getAllBundles());
    }

    public void visitJar(IPath path, XModelObject fs) {
        Set<XModelObject> objects = this.collectXModelBundleObjects(fs, null);
        this.fileSet.setBundles(path, objects);
    }

    private Set<XModelObject> collectXModelBundleObjects(XModelObject o, Set<XModelObject> objects) {
        XModelObject[] children;
        if (objects == null) {
            objects = new HashSet<XModelObject>();
        }
        if (o == null) {
            return objects;
        }
        String path = o.getPath();
        if (path == null || "META-INF".equalsIgnoreCase(o.getAttributeValue("name"))) {
            return objects;
        }
        if (path.endsWith(".properties")) {
            objects.add(o);
        }
        if (o.getFileType() > 1 && o.hasChildren() && (children = o.getChildren()) != null) {
            XModelObject[] xModelObjectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                XModelObject c = xModelObjectArray[n2];
                this.collectXModelBundleObjects(c, objects);
                ++n2;
            }
        }
        return objects;
    }
}

