/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.core.international;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.extension.AbstractDefinitionContextExtension;
import org.jboss.tools.cdi.seam.core.international.CDISeamInternationalExtension;
import org.jboss.tools.cdi.seam.core.international.scanner.BundleFileSet;
import org.jboss.tools.common.model.XModelObject;

public class CDISeamInternationalDefinitionContext
extends AbstractDefinitionContextExtension {
    private Map<IPath, Set<XModelObject>> bundles = new HashMap<IPath, Set<XModelObject>>();
    private Set<XModelObject> allBundles = new HashSet<XModelObject>();

    protected AbstractDefinitionContextExtension copy(boolean clean) {
        CDISeamInternationalDefinitionContext copy = new CDISeamInternationalDefinitionContext();
        copy.root = this.root;
        if (!clean) {
            copy.bundles.putAll(this.bundles);
            copy.allBundles.addAll(this.allBundles);
        }
        return copy;
    }

    protected void doApplyWorkingCopy() {
        CDISeamInternationalDefinitionContext copy = (CDISeamInternationalDefinitionContext)this.workingCopy;
        this.bundles = copy.bundles;
        this.allBundles = copy.allBundles;
    }

    public synchronized void clean() {
        this.bundles.clear();
        this.allBundles.clear();
    }

    public synchronized void clean(IPath path) {
        Set<XModelObject> bs = null;
        bs = this.bundles.remove(path);
        if (bs != null) {
            this.allBundles.removeAll(bs);
        }
    }

    public synchronized void addDefinitions(BundleFileSet fileSet) {
        for (IPath path : fileSet.getAllPaths()) {
            this.clean(path);
            Set<XModelObject> bs = fileSet.getBundles(path);
            this.bundles.put(path, bs);
            this.allBundles.addAll(bs);
        }
    }

    synchronized Set<XModelObject> getBundles() {
        Iterator<XModelObject> i = this.allBundles.iterator();
        while (i.hasNext()) {
            if (i.next().isActive()) continue;
            i.remove();
        }
        return this.allBundles;
    }

    public synchronized Set<XModelObject> getAllBundles() {
        HashSet<XModelObject> result = new HashSet<XModelObject>();
        result.addAll(this.getBundles());
        Set ns = this.root.getProject().getCDIProjects(true);
        for (CDICoreNature n : ns) {
            CDISeamInternationalExtension extension = CDISeamInternationalExtension.getExtension(n);
            if (extension == null) continue;
            result.addAll(extension.getContext().getBundles());
        }
        return result;
    }
}

