/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.internal.management.as70x;

import java.io.IOException;
import java.util.Iterator;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.dmr.ModelNode;
import org.jboss.ide.eclipse.as.internal.management.as70x.OperationRequestBuilder;
import org.jboss.ide.eclipse.as.management.core.DefaultOperationRequestAddress;
import org.jboss.ide.eclipse.as.management.core.OperationFormatException;
import org.jboss.ide.eclipse.as.management.core.OperationRequestAddress;
import org.jboss.ide.eclipse.as.management.core.ValidatingOperationCallbackHandler;

public class DefaultOperationRequestBuilder
extends ValidatingOperationCallbackHandler
implements OperationRequestBuilder {
    private ModelNode request = new ModelNode();
    private OperationRequestAddress prefix;

    public DefaultOperationRequestBuilder() {
        this.prefix = new DefaultOperationRequestAddress();
    }

    public DefaultOperationRequestBuilder(OperationRequestAddress prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix can't be null");
        }
        this.prefix = new DefaultOperationRequestAddress(prefix);
    }

    public void rootNode() {
        this.prefix.reset();
    }

    public void parentNode() {
        this.prefix.toParentNode();
    }

    public void nodeType() {
        this.prefix.toNodeType();
    }

    public void nodeTypeNameSeparator(int index) {
    }

    public void nodeSeparator(int index) {
    }

    public void addressOperationSeparator(int index) {
    }

    public void validatedOperationName(String operationName) {
        this.setOperationName(operationName);
    }

    public void propertyListStart(int index) {
    }

    public void propertyNameValueSeparator(int index) {
    }

    public void propertySeparator(int index) {
    }

    public void propertyListEnd(int index) {
    }

    protected void validatedNodeType(String nodeType) throws OperationFormatException {
        this.addNodeType(nodeType);
    }

    protected void validatedNodeName(String nodeName) throws OperationFormatException {
        this.addNodeName(nodeName);
    }

    protected void validatedPropertyName(String propertyName) throws OperationFormatException {
        throw new OperationFormatException("Property '" + propertyName + "' is missing the value.");
    }

    protected void validatedProperty(String name, String value, int nameValueSeparatorIndex) throws OperationFormatException {
        this.addProperty(name, value);
    }

    public void nodeTypeOrName(String typeOrName) throws OperationFormatException {
        if (this.prefix.endsOnType()) {
            this.addNodeName(typeOrName);
        } else {
            this.addNodeType(typeOrName);
        }
    }

    @Override
    public ModelNode buildRequest() throws OperationFormatException {
        ModelNode address = this.request.get("address");
        if (this.prefix.isEmpty()) {
            address.setEmptyList();
        } else {
            Iterator iterator = this.prefix.iterator();
            while (iterator.hasNext()) {
                OperationRequestAddress.Node node = (OperationRequestAddress.Node)iterator.next();
                if (node.getName() != null) {
                    address.add(node.getType(), node.getName());
                    continue;
                }
                if (!iterator.hasNext()) continue;
                throw new OperationFormatException("The node name is not specified for type '" + node.getType() + "'");
            }
        }
        if (!this.request.hasDefined("operation")) {
            throw new OperationFormatException("The operation name is missing or the format of the operation request is wrong.");
        }
        return this.request;
    }

    @Override
    public void setOperationName(String name) {
        this.request.get("operation").set(name);
    }

    @Override
    public void addNode(String type, String name) {
        this.prefix.toNode(type, name);
    }

    @Override
    public void addNodeType(String type) {
        this.prefix.toNodeType(type);
    }

    @Override
    public void addNodeName(String name) {
        this.prefix.toNode(name);
    }

    @Override
    public void addProperty(String name, String value) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument name is not specified: '" + name + "'");
        }
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument value is not specified: '" + value + "'");
        }
        ModelNode toSet = null;
        try {
            toSet = ModelNode.fromString((String)value);
        }
        catch (Exception exception) {
            toSet = new ModelNode().set(value);
        }
        this.request.get(name).set(toSet);
    }

    public ModelNode getModelNode() {
        return this.request;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
    }
}

