/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.project.capabilities;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.project.capabilities.FileAdditionPerformer;
import org.jboss.tools.jsf.project.capabilities.IPerformerItem;
import org.jboss.tools.jsf.project.capabilities.PerformerContext;
import org.jboss.tools.jsf.project.capabilities.PerformerItem;
import org.jboss.tools.jst.web.project.WebProject;

public class FileAdditionsPerformer
extends PerformerItem {
    XModel model;
    XModelObject capability;
    Map<String, XModelObject> configFiles;
    FileAdditionPerformer[] performers;

    @Override
    public String getDisplayName() {
        return "File Additions";
    }

    @Override
    public IPerformerItem[] getChildren() {
        return this.performers;
    }

    public void init(XModel model, XModelObject capability) {
        this.capability = capability;
        this.configFiles = new HashMap<String, XModelObject>();
        this.model = model;
        this.initPerformers();
    }

    public boolean check() {
        return this.checkPerformers();
    }

    private void initPerformers() {
        XModelObject[] fileAdditions = this.capability.getChildren("JSFFileAddition");
        this.performers = new FileAdditionPerformer[fileAdditions.length];
        int i = 0;
        while (i < fileAdditions.length) {
            this.performers[i] = new FileAdditionPerformer();
            this.performers[i].setParent(this);
            this.performers[i].init(null, fileAdditions[i]);
            ++i;
        }
    }

    private boolean checkPerformers() {
        if (!this.isSelected()) {
            return true;
        }
        XModelObject[] fileAdditions = this.capability.getChildren("JSFFileAddition");
        int i = 0;
        while (i < fileAdditions.length) {
            if (this.performers[i].isSelected()) {
                String filePath = fileAdditions[i].getAttributeValue("file name");
                XModelObject configFile = this.getConfigFile(filePath);
                if (configFile == null) {
                    return false;
                }
                this.performers[i].setConfigFile(configFile);
                if (!this.performers[i].check()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private XModelObject getConfigFile(String filePath) {
        XModelObject configFile = this.configFiles.get(filePath);
        if (configFile == null) {
            configFile = XModelImpl.getByRelativePath((XModel)this.model, (String)filePath);
            if (configFile == null && (configFile = this.selectConfigFile(filePath)) == null) {
                return null;
            }
            this.configFiles.put(filePath, configFile);
        }
        return configFile;
    }

    private XModelObject selectConfigFile(String filePath) {
        SpecialWizard wizard = SpecialWizardFactory.createSpecialWizard((String)"org.jboss.tools.common.model.ui.dialog.SelectEclipseFileWizard");
        IProject project = EclipseResourceUtil.getProject((XModelObject)this.model.getRoot());
        Properties p = new Properties();
        String message = NLS.bind((String)JSFUIMessages.CONFIGURATION_FILE_ISNOT_FOUND_IN_PROJECT, (Object)filePath, (Object)project.getName());
        p.setProperty("message", message);
        p.setProperty("extension", "*");
        p.put("root", project);
        String webRoot = WebProject.getInstance((XModel)this.model).getWebRootLocation();
        String location = String.valueOf(webRoot) + filePath;
        p.setProperty("selection", location);
        wizard.setObject((Object)p);
        int q = wizard.execute();
        Object result = q != 0 ? null : p.get("result");
        IFile f = result instanceof IFile ? (IFile)result : null;
        return f == null ? null : EclipseResourceUtil.getObjectByResource((IResource)f);
    }

    @Override
    public boolean execute(PerformerContext context) throws XModelException {
        if (!this.isSelected()) {
            return true;
        }
        int i = 0;
        while (i < this.performers.length) {
            if (this.performers[i].isSelected()) {
                this.performers[i].execute(context);
            }
            ++i;
        }
        this.saveModifications();
        context.monitor.worked(1);
        return true;
    }

    private void saveModifications() {
        XModelObject[] fs = this.configFiles.values().toArray(new XModelObject[0]);
        int i = 0;
        while (i < fs.length) {
            if (fs[i].isModified()) {
                XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)fs[i], (Properties)new Properties());
            }
            ++i;
        }
    }
}

