/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolutionImpl;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.model.JSFELCompletionEngine;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.internal.XmlContextImpl;
import org.jboss.tools.jst.web.kb.taglib.IELFunction;
import org.jboss.tools.jst.web.kb.taglib.IFunctionLibrary;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.kb.taglib.TagLibraryManager;

public class JSFFuncsELCompletionEngine
extends JSFELCompletionEngine {
    @Override
    protected TypeInfoCollector.MemberInfo getMemberInfoByVariable(JSFELCompletionEngine.IJSFVariable var, ELContext context, boolean onlyEqualNames, int offset) {
        if (!(var instanceof Variable)) {
            return null;
        }
        Variable variable = (Variable)var;
        IType sourceMember = (IType)variable.getSourceMember();
        if (variable.funcResolvedMethod == null) {
            return null;
        }
        TypeInfoCollector.ArtificialTypeInfo result = null;
        try {
            result = new TypeInfoCollector.ArtificialTypeInfo(sourceMember, variable.funcResolvedMethod, variable.funcName);
        }
        catch (JavaModelException e) {
            ELCorePlugin.getPluginLog().logError((Throwable)e);
        }
        return result;
    }

    public ELResolution resolve(ELContext context, ELExpression operand, int offset) {
        if (operand.getText().indexOf(58) > 0) {
            return super.resolve(context, operand, offset);
        }
        return new ELResolutionImpl(operand);
    }

    @Override
    public List<JSFELCompletionEngine.IJSFVariable> resolveVariables(IFile file, ELContext context, ELInvocationExpression expr, boolean isFinal, boolean onlyEqualNames, int offset) {
        return this.resolveVariablesInternal(file, expr, isFinal, onlyEqualNames, offset);
    }

    private List<JSFELCompletionEngine.IJSFVariable> resolveVariablesInternal(IFile file, ELInvocationExpression expr, boolean isFinal, boolean onlyEqualNames, int offset) {
        ELContext context = PageContextFactory.createPageContext((IFile)file);
        if (!(context instanceof XmlContextImpl)) {
            return Collections.emptyList();
        }
        ITagLibrary[] libraries = TagLibraryManager.getLibraries((IProject)file.getProject());
        if (libraries.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<JSFELCompletionEngine.IJSFVariable> result = new ArrayList<JSFELCompletionEngine.IJSFVariable>();
        String varName = expr.toString();
        Map namespacesByOffset = ((XmlContextImpl)context).getNameSpaces(offset);
        ITagLibrary[] iTagLibraryArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            String uri;
            Collection namespaces;
            ITagLibrary l = iTagLibraryArray[n2];
            if (l instanceof IFunctionLibrary && (namespaces = (Collection)namespacesByOffset.get(uri = l.getURI())) != null) {
                for (INameSpace ns : namespaces) {
                    IELFunction[] functions;
                    String name = ns.getPrefix();
                    if ((!isFinal || onlyEqualNames) && !name.equals(varName) || !name.startsWith(varName) || varName.lastIndexOf(46) > name.length() || (functions = ((IFunctionLibrary)l).getFunctions()) == null) continue;
                    IELFunction[] iELFunctionArray = functions;
                    int n3 = functions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IELFunction f = iELFunctionArray[n4];
                        String funcClass = f.getFunctionClass();
                        String funcSignature = f.getFunctionSignature();
                        String funcName = f.getName();
                        Variable v = new Variable(name, file, funcName, funcClass, funcSignature);
                        result.add(v);
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    static class Variable
    implements JSFELCompletionEngine.IJSFVariable {
        IFile f;
        String name;
        String funcName;
        String funcClass;
        String funcSignature;
        IMethod funcResolvedMethod;
        IType funcSourceMember;
        static Map<String, String> WRAPPER_TYPES = new HashMap<String, String>();

        static {
            WRAPPER_TYPES.put("java.lang.Boolean", "boolean");
            WRAPPER_TYPES.put("java.lang.Byte", "byte");
            WRAPPER_TYPES.put("java.lang.Character", "char");
            WRAPPER_TYPES.put("java.lang.Double", "double");
            WRAPPER_TYPES.put("java.lang.Float", "float");
            WRAPPER_TYPES.put("java.lang.Integer", "int");
            WRAPPER_TYPES.put("java.lang.Long", "long");
            WRAPPER_TYPES.put("java.lang.Short", "short");
            WRAPPER_TYPES.put("Boolean", "boolean");
            WRAPPER_TYPES.put("Byte", "byte");
            WRAPPER_TYPES.put("Character", "char");
            WRAPPER_TYPES.put("Double", "double");
            WRAPPER_TYPES.put("Float", "float");
            WRAPPER_TYPES.put("Integer", "int");
            WRAPPER_TYPES.put("Long", "long");
            WRAPPER_TYPES.put("Short", "short");
        }

        public Variable(String name, IFile f, String funcName, String funcClass, String funcSignature) {
            this.name = name;
            this.f = f;
            this.funcName = funcName;
            this.funcClass = funcClass;
            this.funcSignature = funcSignature;
            this.funcResolvedMethod = null;
        }

        public String getName() {
            return this.name;
        }

        public Collection<String> getKeys() {
            String paramsString;
            ArrayList<String> result = new ArrayList<String>();
            if (this.funcResolvedMethod != null) {
                return result;
            }
            if (this.f == null || this.f.getProject() == null) {
                return result;
            }
            int startParamIndex = this.funcSignature.indexOf(40);
            int endParamIndex = this.funcSignature.indexOf(41);
            if (startParamIndex == -1 || endParamIndex == -1 || startParamIndex > endParamIndex) {
                return result;
            }
            String[] s1 = this.funcSignature.substring(0, startParamIndex).trim().split("\\s");
            if (s1.length != 2) {
                return result;
            }
            String funcRetType = s1[0];
            String funcMethodName = s1[1];
            if (funcMethodName.indexOf("<") > 0) {
                funcMethodName = funcMethodName.substring(0, funcMethodName.indexOf("<"));
            }
            String[] params = (paramsString = this.funcSignature.substring(startParamIndex + 1, endParamIndex)).length() == 0 ? new String[]{} : paramsString.split(",");
            this.funcSourceMember = EclipseResourceUtil.getValidType((IProject)this.f.getProject(), (String)this.funcClass);
            if (this.funcSourceMember == null) {
                return result;
            }
            IType currentType = this.funcSourceMember;
            try {
                while (currentType != null) {
                    IMethod[] binMethods = currentType.getMethods();
                    if (binMethods != null) {
                        IMethod[] iMethodArray = binMethods;
                        int n = binMethods.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String methodName;
                            IMethod method = iMethodArray[n2];
                            if (!method.isConstructor() && (method.getFlags() & 8) != 0 && funcMethodName.equals(methodName = method.getElementName())) {
                                String[] methodParamTypes;
                                boolean paramsAreEqual;
                                String methodReturnType;
                                String methodReturnTypeSimple = methodReturnType = method.getReturnType();
                                if (Signature.getTypeSignatureKind((String)methodReturnType) == 2) {
                                    methodReturnTypeSimple = methodReturnType = Signature.toString((String)methodReturnType);
                                } else {
                                    methodReturnType = EclipseJavaUtil.resolveTypeAsString((IType)currentType, (String)methodReturnType);
                                    methodReturnTypeSimple = Signature.getSimpleName((String)methodReturnType);
                                }
                                if ((this.areTypesEqual(funcRetType, methodReturnType) || this.areTypesEqual(funcRetType, methodReturnTypeSimple)) && (paramsAreEqual = this.areParametersEqual(methodParamTypes = method.getParameterTypes(), params, currentType, methodReturnTypeSimple))) {
                                    this.funcResolvedMethod = method;
                                    result.add(this.funcName);
                                    break;
                                }
                            }
                            ++n2;
                        }
                    }
                    currentType = TypeInfoCollector.getSuperclass((IType)currentType);
                }
            }
            catch (JavaModelException e) {
                JSFModelPlugin.getDefault().logError("An error occurred while retrieving methods for type '" + this.funcClass + "'", e);
            }
            return result;
        }

        @Override
        public IMember getSourceMember() {
            this.getKeys();
            return this.funcSourceMember;
        }

        private boolean areParametersEqual(String[] methodParamTypes, String[] params, IType currentType, String methodReturnTypeSimple) {
            int paramsCount;
            int paramTypesCount = methodParamTypes == null ? 0 : methodParamTypes.length;
            int n = paramsCount = params == null ? 0 : params.length;
            if (paramTypesCount != paramsCount) {
                return false;
            }
            int i = 0;
            while (methodParamTypes != null && i < methodParamTypes.length) {
                String methodParamType;
                String methodParamTypeSimple = methodParamType = methodParamTypes[i];
                if (Signature.getTypeSignatureKind((String)methodParamType) == 2) {
                    methodReturnTypeSimple = methodParamType = Signature.toString((String)methodParamType);
                } else {
                    methodParamType = EclipseJavaUtil.resolveTypeAsString((IType)currentType, (String)methodParamType);
                    methodParamTypeSimple = Signature.getSimpleName((String)methodParamType);
                }
                if (params[i] == null || !this.areTypesEqual(params[i], methodParamType) && !this.areTypesEqual(params[i], methodParamTypeSimple)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean areTypesEqual(String type1, String type2) {
            if (type1 == null || type2 == null) {
                return false;
            }
            type1 = this.toPrimitiveType(this.stripTypeName(type1.trim()));
            type2 = this.toPrimitiveType(this.stripTypeName(type2.trim()));
            return type1.equals(type2);
        }

        private String stripTypeName(String type) {
            if (type.endsWith(";")) {
                return type.substring(1, type.length() - 1);
            }
            return type;
        }

        private String toPrimitiveType(String type) {
            return WRAPPER_TYPES.containsKey(type) ? WRAPPER_TYPES.get(type) : type;
        }
    }
}

