/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.jsf.jsf2.model.JSF2ComponentModelManager;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSF2ComponentUtil {
    public static Map<String, List<Element>> findCompositeComponents(Node node) {
        HashMap<String, List<Element>> elementsMap = new HashMap<String, List<Element>>(0);
        JSF2ComponentUtil.findChildCompositeComponents(node, elementsMap);
        return elementsMap;
    }

    private static void findChildCompositeComponents(Node node, Map<String, List<Element>> elementsMap) {
        if (node instanceof IDOMDocument) {
            node = ((IDOMDocument)node).getDocumentElement();
            JSF2ComponentUtil.findChildCompositeComponents(node, elementsMap);
        } else if (node instanceof ElementImpl) {
            NodeList children;
            ElementImpl elementImpl = (ElementImpl)node;
            String namespaceURI = elementImpl.getNamespaceURI();
            if (namespaceURI != null && namespaceURI.startsWith("http://java.sun.com/jsf/composite") && !namespaceURI.equals("http://java.sun.com/jsf/composite")) {
                List<Element> elements = elementsMap.get(namespaceURI);
                if (elements == null) {
                    elements = new ArrayList<Element>(0);
                }
                elements.add((Element)elementImpl);
                elementsMap.put(namespaceURI, elements);
            }
            if ((children = node.getChildNodes()) != null) {
                int i = 0;
                while (i < children.getLength()) {
                    JSF2ComponentUtil.findChildCompositeComponents(children.item(i), elementsMap);
                    ++i;
                }
            }
        }
    }

    public static IDOMAttr[] findURIContainers(Node scanNode) {
        ArrayList<IDOMAttr> attrs = new ArrayList<IDOMAttr>(0);
        JSF2ComponentUtil.findChildURIContainers(scanNode, attrs);
        return attrs.toArray(new IDOMAttr[0]);
    }

    private static void findChildURIContainers(Node node, List<IDOMAttr> attrsList) {
        if (node instanceof IDOMDocument) {
            node = ((IDOMDocument)node).getDocumentElement();
            JSF2ComponentUtil.findChildURIContainers(node, attrsList);
        } else if (node instanceof ElementImpl) {
            NodeList children;
            ElementImpl elementImpl = (ElementImpl)node;
            NamedNodeMap attrsMap = elementImpl.getAttributes();
            if (attrsMap != null && attrsMap.getLength() != 0) {
                int i = 0;
                while (i < attrsMap.getLength()) {
                    String compPath;
                    IDOMAttr attr = (IDOMAttr)attrsMap.item(i);
                    String attrValue = attr.getValue();
                    if (attrValue != null && attrValue.indexOf("http://java.sun.com/jsf/composite") > -1 && !"".equals((compPath = attrValue.replaceFirst("http://java.sun.com/jsf/composite", "")).trim()) && JSF2ComponentUtil.isCorrectCompositeShemaAttrName(attr.getName())) {
                        attrsList.add(attr);
                    }
                    ++i;
                }
            }
            if ((children = node.getChildNodes()) != null) {
                int i = 0;
                while (i < children.getLength()) {
                    JSF2ComponentUtil.findChildURIContainers((Node)((IDOMNode)children.item(i)), attrsList);
                    ++i;
                }
            }
        }
    }

    private static boolean isCorrectCompositeShemaAttrName(String attrName) {
        if (attrName == null) {
            return false;
        }
        if ("xmlns".equals(attrName.trim()) || "uri".equals(attrName.trim())) {
            return true;
        }
        if (attrName.indexOf(58) < 0) {
            return false;
        }
        return "xmlns".equals(attrName = attrName.substring(0, attrName.indexOf(58)).trim());
    }

    public static Map<IFile, List<IDOMNode>> findCompositeComponentsWithURI(IResource resource, String URI2) throws CoreException {
        HashMap<IFile, List<IDOMNode>> nodeMap = new HashMap<IFile, List<IDOMNode>>();
        JSF2ComponentUtil.findCompositeComponentsWithURI(resource, nodeMap, URI2);
        return nodeMap;
    }

    private static void findCompositeComponentsWithURI(IResource resource, Map<IFile, List<IDOMNode>> nodeMap, String URI2) throws CoreException {
        block6: {
            IResource[] children;
            block7: {
                block5: {
                    if (!(resource instanceof IFile)) break block5;
                    IFile file = (IFile)resource;
                    IDOMDocument document = JSF2ComponentModelManager.getReadableDOMDocument(file);
                    Map<String, List<Element>> map = JSF2ComponentUtil.findCompositeComponents((Node)document);
                    Set<Map.Entry<String, List<Element>>> entries = map.entrySet();
                    ArrayList<IDOMNode> nodes = new ArrayList<IDOMNode>();
                    for (Map.Entry<String, List<Element>> entry : entries) {
                        if (!URI2.equals(entry.getKey())) continue;
                        for (Element element : entry.getValue()) {
                            if (!(element instanceof IDOMNode)) continue;
                            nodes.add((IDOMNode)element);
                        }
                    }
                    if (nodes.isEmpty()) break block6;
                    nodeMap.put(file, nodes);
                    break block6;
                }
                if (!(resource instanceof IProject)) break block7;
                IResource[] children2 = ((IProject)resource).members();
                if (children2 == null) break block6;
                int i = 0;
                while (i < children2.length) {
                    JSF2ComponentUtil.findCompositeComponentsWithURI(children2[i], nodeMap, URI2);
                    ++i;
                }
                break block6;
            }
            if (resource instanceof IFolder && (children = ((IFolder)resource).members()) != null) {
                int i = 0;
                while (i < children.length) {
                    JSF2ComponentUtil.findCompositeComponentsWithURI(children[i], nodeMap, URI2);
                    ++i;
                }
            }
        }
    }

    public static IDOMElement findCompositeImpl(Node node) {
        IDOMElement[] compositeImpl = new IDOMElement[1];
        JSF2ComponentUtil.findCompositeImpl(node, compositeImpl);
        return compositeImpl[0];
    }

    private static void findCompositeImpl(Node node, IDOMElement[] interfaceElement) {
        if (node instanceof IDOMDocument) {
            IDOMDocument document = (IDOMDocument)node;
            JSF2ComponentUtil.findCompositeImpl(document.getDocumentElement(), interfaceElement);
        }
        if (node instanceof ElementImpl) {
            ElementImpl impl = (ElementImpl)node;
            String nameSpace = impl.getNamespaceURI();
            if ("http://java.sun.com/jsf/composite".equals(nameSpace)) {
                String nodeName = impl.getLocalName();
                if ("implementation".equals(nodeName)) {
                    interfaceElement[0] = impl;
                    return;
                }
            } else {
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    int i = 0;
                    while (i < nodeList.getLength()) {
                        JSF2ComponentUtil.findCompositeImpl(nodeList.item(i), interfaceElement);
                        ++i;
                    }
                }
            }
        }
    }

    public static IDOMAttr[] extractAttrsWithValue(IDOMElement elToExtract, String value) {
        ArrayList<IDOMAttr> attrs = new ArrayList<IDOMAttr>();
        JSF2ComponentUtil.extractAttrsWithValue(elToExtract, value, attrs);
        return attrs.toArray(new IDOMAttr[0]);
    }

    private static void extractAttrsWithValue(IDOMElement elToExtract, String value, List<IDOMAttr> attrs) {
        NodeList children;
        NamedNodeMap namedNodeMap = elToExtract.getAttributes();
        if (namedNodeMap != null) {
            int i = 0;
            while (i < namedNodeMap.getLength()) {
                IDOMAttr attr = (IDOMAttr)namedNodeMap.item(i);
                if (value.equals(attr.getValue().trim())) {
                    attrs.add(attr);
                }
                ++i;
            }
        }
        if ((children = elToExtract.getChildNodes()) != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node node = children.item(i);
                if (node instanceof IDOMElement) {
                    JSF2ComponentUtil.extractAttrsWithValue((IDOMElement)node, value, attrs);
                }
                ++i;
            }
        }
    }
}

