/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.bean.scanner;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.jsf.JSFModelPlugin;

public class FileSet {
    private Set<IPath> allpaths = new HashSet<IPath>();
    private Set<IPath> nonmodel = new HashSet<IPath>();
    private Map<IPath, Set<IType>> annotations = new HashMap<IPath, Set<IType>>();
    private Map<IPath, Set<IType>> interfaces = new HashMap<IPath, Set<IType>>();
    private Map<IPath, Set<IType>> classes = new HashMap<IPath, Set<IType>>();
    private Map<IPath, IPackageDeclaration> packages = new HashMap<IPath, IPackageDeclaration>();
    private IFile facesConfig = null;
    private static Set<IPath> failedPaths = new HashSet<IPath>();

    public void add(IPath path, IType[] types) throws CoreException {
        this.allpaths.add(path);
        if (types.length == 0) {
            this.nonmodel.add(path);
        } else {
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                this.add(path, type);
                ++n2;
            }
        }
    }

    public void add(IPath path, IType type) throws CoreException {
        this.allpaths.add(path);
        if (this.checkType(type, path)) {
            if (type.isAnnotation()) {
                this.add(this.annotations, path, type);
            } else if (type.isInterface()) {
                this.add(this.interfaces, path, type);
            } else {
                IType[] ts;
                this.add(this.classes, path, type);
                IType[] iTypeArray = ts = type.getTypes();
                int n = ts.length;
                int n2 = 0;
                while (n2 < n) {
                    IType t = iTypeArray[n2];
                    if (this.checkType(t, path) && Flags.isStatic((int)t.getFlags())) {
                        this.add(path, t);
                    }
                    ++n2;
                }
            }
        }
    }

    private boolean checkType(IType type, IPath path) throws CoreException {
        try {
            type.isAnnotation();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (failedPaths.contains(path)) {
                return false;
            }
            failedPaths.add(path);
            JSFModelPlugin.getDefault().logError("JDT failed to load " + type.getFullyQualifiedName() + " from " + path + "\nSee https://bugs.eclipse.org/bugs/show_bug.cgi?id=342757");
            return false;
        }
        return true;
    }

    private void add(Map<IPath, Set<IType>> target, IPath path, IType type) {
        Set<IType> ts = target.get(path);
        if (ts == null) {
            ts = new HashSet<IType>();
            target.put(path, ts);
        }
        ts.add(type);
    }

    public void add(IPath path, IPackageDeclaration pkg) throws CoreException {
        this.allpaths.add(path);
        this.packages.put(path, pkg);
    }

    public void setFacesConfig(IFile facesConfig) {
        this.facesConfig = facesConfig;
    }

    public Set<IPath> getAllPaths() {
        return this.allpaths;
    }

    public Set<IPath> getNonModelFiles() {
        return this.nonmodel;
    }

    public Map<IPath, Set<IType>> getAnnotations() {
        return this.annotations;
    }

    public Map<IPath, Set<IType>> getInterfaces() {
        return this.interfaces;
    }

    public Map<IPath, Set<IType>> getClasses() {
        return this.classes;
    }

    public Map<IPath, IPackageDeclaration> getPackages() {
        return this.packages;
    }

    public IFile getFacesConfig() {
        return this.facesConfig;
    }
}

