/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.plugin;

import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class BaseUISharedImages {
    private Hashtable<String, Image> images;
    private Hashtable<String, ImageDescriptor> descriptors;
    private Bundle pluginBundle;

    public BaseUISharedImages(Bundle pluginBundle) {
        this.pluginBundle = pluginBundle;
        this.images = new Hashtable();
        this.descriptors = new Hashtable();
    }

    protected void addImage(String key, String path) {
        ImageDescriptor id = this.createImageDescriptor(path);
        if (id != null) {
            this.addDescriptor(this.descriptors, key, id);
        }
    }

    protected ImageDescriptor createImageDescriptor(String path) {
        return this.createImageDescriptor(this.pluginBundle, path);
    }

    protected void addDescriptor(Hashtable<String, ImageDescriptor> map, String key, ImageDescriptor val) {
        map.put(key, val);
    }

    private ImageDescriptor createImageDescriptor(Bundle pluginBundle, String relativePath) {
        return ImageDescriptor.createFromURL((URL)pluginBundle.getEntry(relativePath));
    }

    public Image image(String key) {
        Image image = this.images.get(key);
        if (image == null || image.isDisposed()) {
            ImageDescriptor desc = this.descriptors.get(key);
            if (desc == null) {
                return null;
            }
            this.images.put(key, desc.createImage());
        }
        return this.images.get(key);
    }

    public ImageDescriptor descriptor(String key) {
        return this.descriptors.get(key);
    }

    public void dispose() {
        Iterator<String> iter = this.images.keySet().iterator();
        while (iter.hasNext()) {
            Image image = this.images.get(iter.next());
            image.dispose();
        }
        this.images.clear();
        this.descriptors.clear();
        this.images = null;
        this.descriptors = null;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }
}

