/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.credentials.internal;

import java.util.Arrays;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.foundation.core.credentials.ICredentialDomain;
import org.jboss.tools.foundation.core.credentials.ICredentialsModel;
import org.jboss.tools.foundation.ui.credentials.internal.CredentialMessages;
import org.jboss.tools.foundation.ui.util.FormDataUtility;

public class NewCredentialUserDialog
extends TitleAreaDialog {
    private ICredentialsModel model;
    private ICredentialDomain selectedDomain;
    private String user;
    private String pass;
    private String[] domainNames;
    private ICredentialDomain[] allDomains;
    private boolean freezeUser = false;
    private boolean freezeDomain = false;
    private boolean alwaysPrompt = false;

    public NewCredentialUserDialog(Shell parentShell, ICredentialsModel model, ICredentialDomain selected) {
        super(parentShell);
        this.model = model;
        this.selectedDomain = selected;
        if (selected != null) {
            this.freezeDomain = true;
        }
    }

    public NewCredentialUserDialog(Shell parentShell, ICredentialsModel model, ICredentialDomain selected, String user) {
        super(parentShell);
        this.model = model;
        this.selectedDomain = selected;
        this.user = user;
        this.freezeDomain = true;
        this.freezeUser = true;
        this.alwaysPrompt = model.credentialRequiresPrompt(selected, user);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setBounds(shell.getLocation().x, shell.getLocation().y, 550, 500);
        Shell s2 = shell.getParent().getShell();
        if (s2 != null) {
            shell.setLocation(s2.getLocation());
        }
        if (this.freezeUser) {
            shell.setText(CredentialMessages.EditACredentialLabel);
        } else {
            shell.setText(CredentialMessages.AddACredentialLabel);
        }
    }

    protected int getShellStyle() {
        int ret = super.getShellStyle();
        return ret | 0x10;
    }

    protected Control createDialogArea(Composite parent) {
        int sIndex;
        if (this.freezeUser) {
            this.setTitle(CredentialMessages.EditACredentialLabel);
        } else {
            this.setTitle(CredentialMessages.AddACredentialLabel);
        }
        Composite main = new Composite((Composite)super.createDialogArea(parent), 0);
        main.setLayoutData((Object)new GridData(1808));
        main.setLayout((Layout)new FormLayout());
        final Combo domains = new Combo(main, 2060);
        Label l = new Label(main, 0);
        l.setText(CredentialMessages.DomainLabel);
        this.allDomains = this.model.getDomains();
        this.domainNames = new String[this.allDomains.length];
        int i = 0;
        while (i < this.allDomains.length) {
            this.domainNames[i] = this.allDomains[i].getName();
            ++i;
        }
        domains.setItems(this.domainNames);
        if (this.selectedDomain != null && (sIndex = Arrays.asList(this.allDomains).indexOf(this.selectedDomain)) != -1) {
            domains.select(sIndex);
        }
        Label nameLabel = new Label(main, 0);
        nameLabel.setText(CredentialMessages.UsernameLabel);
        final Text nameText = new Text(main, 2052);
        final Button promptBtn = new Button(main, 32);
        promptBtn.setText("Always prompt for password.");
        promptBtn.setSelection(this.alwaysPrompt);
        Label passLabel = new Label(main, 0);
        passLabel.setText(CredentialMessages.PasswordLabel);
        final Text passText = new Text(main, 0x400804);
        if (this.user != null) {
            nameText.setText(this.user);
        }
        l.setLayoutData((Object)new FormDataUtility().createFormData(0, 12, null, 0, 0, 10, null, 0));
        domains.setLayoutData((Object)new FormDataUtility().createFormData(0, 8, null, 0, 25, 0, 100, -5));
        nameLabel.setLayoutData((Object)new FormDataUtility().createFormData(l, 19, null, 0, 0, 10, null, 0));
        nameText.setLayoutData((Object)new FormDataUtility().createFormData(l, 15, null, 0, 25, 0, 100, -5));
        promptBtn.setLayoutData((Object)new FormDataUtility().createFormData(nameLabel, 19, null, 0, 0, 10, 100, -5));
        passLabel.setLayoutData((Object)new FormDataUtility().createFormData(promptBtn, 19, null, 0, 0, 10, null, 0));
        passText.setLayoutData((Object)new FormDataUtility().createFormData(promptBtn, 15, null, 0, 25, 0, 100, -5));
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewCredentialUserDialog.this.user = nameText.getText();
                NewCredentialUserDialog.this.validate();
            }
        });
        promptBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                passText.setEnabled(!promptBtn.getSelection());
                NewCredentialUserDialog.this.alwaysPrompt = promptBtn.getSelection();
                NewCredentialUserDialog.this.validate();
            }
        });
        passText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewCredentialUserDialog.this.pass = passText.getText();
                NewCredentialUserDialog.this.validate();
            }
        });
        domains.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = domains.getSelectionIndex();
                if (i != -1) {
                    NewCredentialUserDialog.this.selectedDomain = NewCredentialUserDialog.this.allDomains[i];
                }
                NewCredentialUserDialog.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.freezeDomain) {
            domains.setEnabled(false);
        }
        if (this.freezeUser) {
            nameText.setEnabled(false);
        }
        if (this.alwaysPrompt) {
            passText.setEnabled(false);
        }
        return main;
    }

    private void validate() {
        if (this.selectedDomain == null) {
            this.setMessage(CredentialMessages.SelectDomain, 3);
            this.getButton(0).setEnabled(false);
            return;
        }
        if (this.user == null || this.user.isEmpty()) {
            this.setMessage(CredentialMessages.UsernameCannotBeBlank, 3);
            this.getButton(0).setEnabled(false);
            return;
        }
        String[] names = this.selectedDomain.getUsernames();
        if (!this.freezeUser && Arrays.asList(names).contains(this.user)) {
            this.setMessage(NLS.bind((String)CredentialMessages.UsernameAlreadyExists, (Object)this.user, (Object)this.selectedDomain.getName()), 3);
            this.getButton(0).setEnabled(false);
            return;
        }
        if (!this.alwaysPrompt && (this.pass == null || this.pass.isEmpty())) {
            this.setMessage(CredentialMessages.PasswordCannotBeBlank, 3);
            this.getButton(0).setEnabled(false);
            return;
        }
        this.setMessage(null, 0);
        this.getButton(0).setEnabled(true);
    }

    public ICredentialDomain getDomain() {
        return this.selectedDomain;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isAlwaysPrompt() {
        return this.alwaysPrompt;
    }

    public String getPass() {
        return this.pass;
    }
}

