/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.credentials.internal;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.jboss.tools.foundation.core.credentials.ICredentialDomain;
import org.jboss.tools.foundation.ui.credentials.internal.CredentialMessages;

public class CredentialPromptDialog
extends FormDialog {
    protected Text password;
    private Label statusLabel;
    protected Button showPassword;
    protected Button okButton;
    protected String providedPassword;
    private ICredentialDomain domain;
    private String user;

    public CredentialPromptDialog(ICredentialDomain domain, String user) {
        super(CredentialPromptDialog.getWorkbenchShell());
        this.domain = domain;
        this.user = user;
    }

    private static Shell getWorkbenchShell() {
        IWorkbenchWindow window;
        if (PlatformUI.isWorkbenchRunning() && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            return window.getShell();
        }
        return null;
    }

    public String getPassword() {
        return this.providedPassword;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, CredentialMessages.OK, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, CredentialMessages.Cancel, false);
    }

    protected boolean isResizable() {
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(CredentialMessages.CredentialPrompterTitle);
        shell.setSize(700, 250);
    }

    protected void createFormContent(IManagedForm mform) {
        final ScrolledForm mainForm = mform.getForm();
        FormToolkit toolkit = new FormToolkit(mainForm.getDisplay());
        Composite body = mainForm.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        body.setLayout((Layout)layout);
        Section descriptionSection = toolkit.createSection(body, 322);
        descriptionSection.setText(CredentialMessages.DescriptionSectionTitle);
        descriptionSection.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        FormText descriptionText = toolkit.createFormText((Composite)descriptionSection, true);
        descriptionText.setText(NLS.bind((String)CredentialMessages.DescriptionSectionContent, (Object)this.user, (Object)this.domain.getName()), true, true);
        TableWrapData td = new TableWrapData(128);
        td.colspan = 1;
        descriptionText.setLayoutData((Object)td);
        descriptionSection.setClient((Control)descriptionText);
        toolkit.createLabel(body, "");
        Section passwordSection = toolkit.createSection(body, 322);
        passwordSection.setText("");
        passwordSection.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        passwordSection.setLayoutData((Object)td);
        Composite passwordComposite = toolkit.createComposite((Composite)passwordSection, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(passwordComposite);
        Label passwordLabel = toolkit.createLabel(passwordComposite, CredentialMessages.PasswordLabel2, 16384);
        GridDataFactory.swtDefaults().applyTo((Control)passwordLabel);
        this.password = toolkit.createText(passwordComposite, "", 18432);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.password);
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                CredentialPromptDialog.this.okButton.setEnabled(CredentialPromptDialog.this.validatePassword(mainForm));
            }
        });
        this.password.setFocus();
        Label fillerLabel = toolkit.createLabel(passwordComposite, "", 16384);
        GridDataFactory.swtDefaults().applyTo((Control)fillerLabel);
        this.showPassword = toolkit.createButton(passwordComposite, CredentialMessages.ShowPasswordLabel, 131104);
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)this.showPassword);
        this.showPassword.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CredentialPromptDialog.this.passwordVisibility();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CredentialPromptDialog.this.passwordVisibility();
            }
        });
        this.showPassword.setSelection(false);
        this.passwordVisibility();
        passwordSection.setClient((Control)passwordComposite);
        toolkit.createLabel(body, "");
        this.statusLabel = toolkit.createLabel(body, "");
        TableWrapData td2 = new TableWrapData(128);
        td2.colspan = 1;
        td2.grabHorizontal = true;
        this.statusLabel.setLayoutData((Object)td2);
        this.statusLabel.setForeground(mainForm.getDisplay().getSystemColor(3));
    }

    protected void passwordVisibility() {
        boolean selected = this.showPassword.getSelection();
        if (selected) {
            this.password.setEchoChar('\u0000');
        } else {
            this.password.setEchoChar('*');
        }
    }

    protected boolean validatePassword(ScrolledForm mainForm) {
        String password1 = this.password.getText();
        if (password1 == null || password1.length() == 0) {
            this.statusLabel.setText(CredentialMessages.MessageEmptyPassword);
            return false;
        }
        this.statusLabel.setText("");
        return true;
    }

    protected void okPressed() {
        this.providedPassword = this.password.getText();
        super.okPressed();
    }
}

