/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.LinkedHashSet;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetInstallDataModelProvider;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.wtp.AbstractProjectConfiguratorDelegate;
import org.eclipse.m2e.wtp.EjbPluginConfiguration;
import org.eclipse.m2e.wtp.ResourceCleaner;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

class EjbProjectConfiguratorDelegate
extends AbstractProjectConfiguratorDelegate {
    EjbProjectConfiguratorDelegate() {
    }

    @Override
    protected void configure(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project.getFile("pom.xml"), true, monitor);
        LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>();
        this.installJavaFacet(actions, project, facetedProject);
        EjbPluginConfiguration config = new EjbPluginConfiguration(mavenProject);
        String contentDir = config.getEjbContentDirectory(project);
        IProjectFacetVersion ejbFv = config.getEjbFacetVersion();
        if (!facetedProject.hasProjectFacet(WTPProjectsUtil.EJB_FACET)) {
            WTPProjectsUtil.removeConflictingFacets(facetedProject, ejbFv, actions);
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, ejbFv, this.getEjbDataModel(contentDir)));
        } else {
            IProjectFacetVersion projectFacetVersion = facetedProject.getProjectFacetVersion(WTPProjectsUtil.EJB_FACET);
            if (ejbFv.getVersionString() != null && !ejbFv.getVersionString().equals(projectFacetVersion.getVersionString())) {
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, ejbFv, this.getEjbDataModel(contentDir)));
            }
        }
        if (!actions.isEmpty()) {
            ResourceCleaner fileCleaner = new ResourceCleaner(project);
            try {
                this.addFoldersToClean(fileCleaner, facade);
                facetedProject.modify(actions, monitor);
            }
            finally {
                fileCleaner.cleanUp();
            }
        }
        this.fixMissingModuleCoreNature(project, monitor);
        this.removeTestFolderLinks(project, mavenProject, monitor, "/");
        IVirtualComponent ejbComponent = ComponentCore.createComponent((IProject)project);
        if (ejbComponent != null) {
            IPath contentDirPath = new Path("/").append(contentDir);
            WTPProjectsUtil.setDefaultDeploymentDescriptorFolder(ejbComponent.getRootFolder(), contentDirPath, monitor);
        }
        this.setNonDependencyAttributeToContainer(project, monitor);
        WTPProjectsUtil.removeWTPClasspathContainer(project);
    }

    private Object getEjbDataModel(String contentDir) {
        IDataModel ejbModelCfg = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetInstallDataModelProvider());
        ejbModelCfg.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)contentDir);
        ejbModelCfg.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        return ejbModelCfg;
    }

    @Override
    public void setModuleDependencies(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    protected void addFoldersToClean(ResourceCleaner fileCleaner, IMavenProjectFacade facade) {
        super.addFoldersToClean(fileCleaner, facade);
        this.cleanEjbJar(fileCleaner, facade.getCompileSourceLocations());
        this.cleanEjbJar(fileCleaner, facade.getResourceLocations());
        Path defaultResource = new Path("src/main/resources");
        fileCleaner.addFiles(defaultResource.append("META-INF/ejb-jar.xml"));
    }

    private void cleanEjbJar(ResourceCleaner fileCleaner, IPath[] directories) {
        IPath[] iPathArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFiles(p.append("META-INF/ejb-jar.xml"));
            }
            ++n2;
        }
    }
}

