/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.providers;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.ide.eclipse.archives.ui.PrefsInitializer;
import org.jboss.ide.eclipse.archives.ui.providers.ArchivesContentProviderDelegate;
import org.jboss.ide.eclipse.archives.ui.views.ProjectArchivesCommonView;

public class ArchivesRootContentProvider
implements ITreeContentProvider {
    public static final Object NO_PROJECT = new Object();
    private ArchivesContentProviderDelegate delegate = new ArchivesContentProviderDelegate(1);

    public Object[] getChildren(Object parentElement) {
        return this.delegate.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.delegate.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return this.delegate.hasChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        IProject cp = ProjectArchivesCommonView.getInstance().getCurrentProject();
        if (this.showProjectRoot()) {
            if (this.showAllProjects()) {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                ArrayList<IProject> tmp = new ArrayList<IProject>();
                int i = 0;
                while (i < projects.length) {
                    if (projects[i].isAccessible()) {
                        tmp.add(projects[i]);
                    }
                    ++i;
                }
                return this.wrap(tmp.toArray(new IProject[tmp.size()]));
            }
            if (cp != null && cp.isAccessible()) {
                return this.wrap(new IProject[]{cp});
            }
        } else if (cp != null) {
            return this.getChildren(new ArchivesContentProviderDelegate.WrappedProject(cp, 1));
        }
        return new Object[]{NO_PROJECT};
    }

    protected Object[] wrap(IProject[] objs) {
        Object[] projs = new ArchivesContentProviderDelegate.WrappedProject[objs.length];
        int i = 0;
        while (i < projs.length) {
            projs[i] = new ArchivesContentProviderDelegate.WrappedProject(objs[i], 1);
            ++i;
        }
        return projs;
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.delegate.inputChanged(viewer, oldInput, newInput);
    }

    private boolean showProjectRoot() {
        return PrefsInitializer.getBoolean("showProjectRoot");
    }

    private boolean showAllProjects() {
        return PrefsInitializer.getBoolean("showAllProjects");
    }
}

