/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.MultiTextEdit;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.internal.core.refactoring.CDIRefactoringProcessor;

public class DeleteOtherAnnotationsFromParametersProcessor
extends CDIRefactoringProcessor {
    private ILocalVariable parameter;
    private String annotationName;

    public DeleteOtherAnnotationsFromParametersProcessor(IFile file, String annotationName, ILocalVariable parameter, String label) {
        super(file, label);
        this.parameter = parameter;
        this.annotationName = annotationName;
    }

    private void change() throws JavaModelException {
        if (this.parameter.getParent() instanceof IMethod) {
            IMethod method = (IMethod)this.parameter.getParent();
            ICompilationUnit original = method.getCompilationUnit();
            ICompilationUnit compilationUnit = original.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            ILocalVariable[] iLocalVariableArray = method.getParameters();
            int n = iLocalVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalVariable param = iLocalVariableArray[n2];
                if (!param.getTypeSignature().equals(this.parameter.getTypeSignature()) || !param.getElementName().equals(this.parameter.getElementName())) {
                    CDIMarkerResolutionUtils.deleteAnnotation((String)this.annotationName, (ICompilationUnit)compilationUnit, (IJavaElement)param, (MultiTextEdit)((MultiTextEdit)this.change.getEdit()));
                }
                ++n2;
            }
            compilationUnit.discardWorkingCopy();
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        this.createRootChange();
        this.change();
        return this.status;
    }
}

