/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.extension.CDIExtensionManager;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.java.ParametedTypeFactory;
import org.jboss.tools.common.util.UniquePaths;

public abstract class CDIElement
implements ICDIElement {
    static int LAST_ID = 0;
    protected int id;
    protected ICDIElement parent;
    protected IPath source;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDIElement() {
        CDIElement cDIElement = this;
        synchronized (cDIElement) {
            this.id = LAST_ID++;
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public ICDIProject getCDIProject() {
        return this.parent != null ? this.parent.getCDIProject() : null;
    }

    @Override
    public ICDIProject getDeclaringProject() {
        return this.parent != null ? this.parent.getDeclaringProject() : null;
    }

    public CDIExtensionManager getExtensionManager() {
        ICDIProject project = this.getCDIProject();
        return project == null ? null : project.getNature().getExtensionManager();
    }

    protected ParametedType getObjectType(IMember context) {
        try {
            return this.getCDIProject().getNature().getTypeFactory().getParametedType(context, ParametedTypeFactory.OBJECT);
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
            return null;
        }
    }

    public void setParent(ICDIElement parent) {
        this.parent = parent;
    }

    public ICDIElement getParent() {
        return this.parent;
    }

    @Override
    public IResource getResource() {
        IPath path = this.getSourcePath();
        if (path == null) {
            return null;
        }
        IFile r = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (r == null || !r.exists()) {
            return null;
        }
        return r;
    }

    @Override
    public IPath getSourcePath() {
        return this.source != null ? this.source : (this.parent != null ? this.parent.getSourcePath() : null);
    }

    public void setSourcePath(IPath source) {
        if (source != null) {
            source = UniquePaths.getInstance().intern(source);
        }
        this.source = source;
    }

    @Override
    public boolean exists() {
        return this.parent != null && this.parent.exists();
    }
}

