/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.core.extension;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.IExtensionRecognizer;
import org.jboss.tools.cdi.core.extension.feature.ICDIFeature;

public class CDIExtensionFactory {
    static CDIExtensionFactory factory = null;
    public static String POINT_ID = "org.jboss.tools.cdi.core.cdiextensions";
    private Map<String, Set<String>> runtimeToDesign = new HashMap<String, Set<String>>();
    private Map<Class<? extends ICDIExtension>, Set<Class<?>>> designToFeatures = new HashMap();
    Map<String, Class<? extends ICDIExtension>> designToClass = new HashMap<String, Class<? extends ICDIExtension>>();
    Map<String, IExtensionRecognizer> recognizers = new HashMap<String, IExtensionRecognizer>();
    Map<Class<?>, Boolean> featureCheck = new HashMap();

    public static CDIExtensionFactory getInstance() {
        if (factory == null) {
            factory = new CDIExtensionFactory();
        }
        return factory;
    }

    private CDIExtensionFactory() {
        this.load();
    }

    private void load() {
        IConfigurationElement[] cs;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(POINT_ID);
        IConfigurationElement[] iConfigurationElementArray = cs = point.getConfigurationElements();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                IConfigurationElement c = iConfigurationElementArray[n2];
                String runtime = c.getAttribute("runtime");
                String cls = c.getAttribute("class");
                String recognizer = c.getAttribute("recognizer");
                ICDIExtension extension = null;
                try {
                    Object o = c.createExecutableExtension("class");
                    if (!(o instanceof ICDIExtension)) {
                        CDICorePlugin.getDefault().logError("CDI extension " + cls + " should implement ICDIExtension.");
                    } else {
                        extension = (ICDIExtension)o;
                    }
                }
                catch (CoreException e) {
                    CDICorePlugin.getDefault().logError(e);
                    break block12;
                }
                if (extension != null) {
                    this.designToClass.put(cls, extension.getClass());
                    Set<String> classes = this.runtimeToDesign.get(runtime);
                    if (classes == null) {
                        classes = new HashSet<String>();
                        this.runtimeToDesign.put(runtime, classes);
                    }
                    classes.add(cls);
                    if (recognizer != null) {
                        try {
                            Object o = c.createExecutableExtension("recognizer");
                            if (!(o instanceof IExtensionRecognizer)) {
                                CDICorePlugin.getDefault().logError("CDI extension recognizer " + recognizer + " should implement IExtensionRecognizer.");
                            } else {
                                this.recognizers.put(runtime, (IExtensionRecognizer)o);
                            }
                        }
                        catch (CoreException e) {
                            CDICorePlugin.getDefault().logError(e);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public Set<Class<?>> getFeatures(ICDIExtension extension) {
        Set<Class<?>> result = this.designToFeatures.get(extension.getClass());
        if (result == null) {
            result = new HashSet();
            this.getFeatures(extension.getClass(), result);
        }
        return result;
    }

    void getFeatures(Class<?> cls, Set<Class<?>> result) {
        Class<?> s;
        Class<?>[] is;
        if (cls == ICDIFeature.class) {
            return;
        }
        if (this.isFeature(cls)) {
            result.add(cls);
        }
        Class<?>[] classArray = is = cls.getInterfaces();
        int n = is.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            this.getFeatures(c, result);
            ++n2;
        }
        if (!cls.isInterface() && (s = cls.getSuperclass()) != null) {
            this.getFeatures(s, result);
        }
    }

    boolean isFeature(Class<?> cls) {
        if (!cls.isInterface()) {
            return false;
        }
        Boolean b = this.featureCheck.get(cls);
        if (b == null) {
            Class<?>[] is;
            Class<?>[] classArray = is = cls.getInterfaces();
            int n = is.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> c = classArray[n2];
                if (c == ICDIFeature.class || this.isFeature(c)) {
                    b = Boolean.TRUE;
                }
                ++n2;
            }
            if (b == null) {
                b = Boolean.FALSE;
            }
            this.featureCheck.put(cls, b);
        }
        return b;
    }

    public Set<String> getExtensionClassesByRuntime(String qualifiedName) {
        return this.runtimeToDesign.get(qualifiedName);
    }

    public ICDIExtension createExtensionInstance(String qualifiedName) {
        Class<? extends ICDIExtension> cls = this.designToClass.get(qualifiedName);
        if (cls != null) {
            try {
                return cls.newInstance();
            }
            catch (InstantiationException e1) {
                CDICorePlugin.getDefault().logError(e1);
            }
            catch (IllegalAccessException e2) {
                CDICorePlugin.getDefault().logError(e2);
            }
        }
        return null;
    }

    public Set<String> getRecognizedRuntimes(IJavaProject javaProject) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, IExtensionRecognizer> entry : this.recognizers.entrySet()) {
            String runtime = entry.getKey();
            IExtensionRecognizer recognizer = entry.getValue();
            if (!recognizer.containsExtension(runtime, javaProject)) continue;
            result.add(runtime);
        }
        return result;
    }

    static <F> F adaptTo(ICDIExtension extension, Class<F> feature) {
        if (extension == null || feature == null) {
            return null;
        }
        Class<?> cls = extension.getClass();
        if (feature.isAssignableFrom(cls)) {
            return (F)extension;
        }
        if (extension instanceof IAdaptable) {
            return (F)((IAdaptable)extension).getAdapter(feature);
        }
        return null;
    }
}

