/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.core;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.IBeanField;
import org.jboss.tools.cdi.core.IBeanMethod;
import org.jboss.tools.cdi.core.ICDIAnnotation;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.internal.core.impl.EventBean;
import org.jboss.tools.cdi.xml.CDIXMLImages;
import org.jboss.tools.common.ui.CommonUIImages;

public class CDIImages
extends CommonUIImages {
    private static CDIImages INSTANCE;
    public static final ImageDescriptor CDI_BEAN_IMAGE;
    public static final ImageDescriptor WELD_IMAGE;
    public static final ImageDescriptor BEAN_CLASS_IMAGE;
    public static final ImageDescriptor BEAN_METHOD_IMAGE;
    public static final ImageDescriptor BEAN_FIELD_IMAGE;
    public static final ImageDescriptor INJECTION_POINT_IMAGE;
    public static final ImageDescriptor ANNOTATION_IMAGE;
    public static final ImageDescriptor CDI_EVENT_IMAGE;
    public static final ImageDescriptor BEANS_XML_IMAGE;
    public static final ImageDescriptor MESSAGE_BUNDLE_IMAGE;
    public static final ImageDescriptor QUICKFIX_ADD;
    public static final ImageDescriptor QUICKFIX_REMOVE;
    public static final ImageDescriptor QUICKFIX_EDIT;
    public static final ImageDescriptor QUICKFIX_CHANGE;
    public static final String CDI_PROJECT_IMAGE = "wizard/CDIProjectWizBan.png";
    public static final String CDI_BEANS_XML_IMAGE = "wizard/CDIBeansXMLWizBan.png";
    public static final String CDI_CLASS_IMAGE = "wizard/CDIClassWizBan.png";
    public static final String CDI_ANNOTATION_IMAGE = "wizard/CDIAnnotationWizBan.png";

    static {
        try {
            INSTANCE = new CDIImages(new URL(CDICorePlugin.getDefault().getBundle().getEntry("/"), "images/"));
        }
        catch (MalformedURLException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        CDI_BEAN_IMAGE = CDIImages.getImageDescriptor("search/cdi_bean.gif");
        WELD_IMAGE = CDIImages.getImageDescriptor("search/weld_icon_16x.gif");
        BEAN_CLASS_IMAGE = CDIXMLImages.BEAN_CLASS_IMAGE;
        BEAN_METHOD_IMAGE = CDIImages.getImageDescriptor("bean_method.png");
        BEAN_FIELD_IMAGE = CDIImages.getImageDescriptor("bean_field.png");
        INJECTION_POINT_IMAGE = CDIImages.getImageDescriptor("injection_point.png");
        ANNOTATION_IMAGE = CDIXMLImages.ANNOTATION_IMAGE;
        CDI_EVENT_IMAGE = CDIImages.getImageDescriptor("event.png");
        BEANS_XML_IMAGE = CDIXMLImages.BEANS_XML_IMAGE;
        MESSAGE_BUNDLE_IMAGE = CDIImages.getImageDescriptor("message_bundle.gif");
        QUICKFIX_ADD = CDIImages.getImageDescriptor("quickfixes/cdi_add.png");
        QUICKFIX_REMOVE = CDIImages.getImageDescriptor("quickfixes/cdi_remove.png");
        QUICKFIX_EDIT = CDIImages.getImageDescriptor("quickfixes/cdi_edit.png");
        QUICKFIX_CHANGE = CDIImages.getImageDescriptor("quickfixes/cdi_change.png");
    }

    public static Image getImage(String key) {
        return CDIImages.getImageDescriptor(key).createImage();
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return CDIImages.getInstance().getOrCreateImageDescriptor(key);
    }

    public static void setImageDescriptors(IAction action, String iconName) {
        action.setImageDescriptor(INSTANCE.createImageDescriptor(iconName));
    }

    public static CDIImages getInstance() {
        return INSTANCE;
    }

    protected CDIImages(URL registryUrl, CDIImages parent) {
        super(registryUrl, (CommonUIImages)parent);
    }

    protected CDIImages(URL url) {
        this(url, null);
    }

    protected ImageRegistry getImageRegistry() {
        return CDICorePlugin.getDefault().getImageRegistry();
    }

    public static Image getImageByElement(ICDIElement element) {
        return CDIImages.getImage((ImageDescriptor)CDIImages.getImageDescriptorByElement(element));
    }

    public static ImageDescriptor getImageDescriptorByElement(ICDIElement element) {
        if (element instanceof IClassBean) {
            return BEAN_CLASS_IMAGE;
        }
        if (element instanceof IInjectionPoint) {
            return INJECTION_POINT_IMAGE;
        }
        if (element instanceof ICDIAnnotation) {
            return ANNOTATION_IMAGE;
        }
        if (element instanceof EventBean) {
            return CDI_EVENT_IMAGE;
        }
        if (element instanceof IBeanMethod) {
            return BEAN_METHOD_IMAGE;
        }
        if (element instanceof IBeanField) {
            return BEAN_FIELD_IMAGE;
        }
        return WELD_IMAGE;
    }

    public static /* bridge */ /* synthetic */ CommonUIImages getInstance() {
        return CDIImages.getInstance();
    }
}

