/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.wizard;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.runtime.core.extract.IOverwrite;
import org.jboss.tools.runtime.core.model.RuntimePath;
import org.jboss.tools.runtime.core.util.RuntimeInitializerUtil;
import org.jboss.tools.runtime.core.util.internal.DownloadRuntimeOperationUtility;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.internal.Messages;
import org.jboss.tools.runtime.ui.internal.dialogs.SearchRuntimePathDialog;

public class DownloadRuntimeOperationUIUtility
extends DownloadRuntimeOperationUtility {
    public static IStatus createRuntimes(String directory, IProgressMonitor monitor) {
        IStatus ret = Status.OK_STATUS;
        monitor.subTask("Creating runtime from location " + directory);
        RuntimePath runtimePath = new RuntimePath(directory);
        List runtimeDefinitions = RuntimeInitializerUtil.createRuntimeDefinitions((RuntimePath)runtimePath, (IProgressMonitor)monitor);
        RuntimeUIActivator.getDefault().getModel().addRuntimePath(runtimePath);
        if (runtimeDefinitions.size() == 0) {
            return new Status(4, "org.jboss.tools.runtime.ui", NLS.bind((String)Messages.DownloadRuntimesSecondPage_No_runtime_server_found, (Object)directory));
        }
        if (runtimeDefinitions.size() > 1) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SearchRuntimePathDialog.launchSearchRuntimePathDialog(Display.getDefault().getActiveShell(), RuntimeUIActivator.getDefault().getModel().getRuntimePaths(), false, 7);
                }
            });
        } else {
            ret = RuntimeInitializerUtil.initializeRuntimes((List)runtimeDefinitions);
        }
        monitor.done();
        return ret;
    }

    public static IOverwrite createOverwriteFileQuery() {
        IOverwrite overwriteQuery = new IOverwrite(){

            public int overwrite(File file) {
                final String msg = NLS.bind((String)Messages.DownloadRuntimesSecondPage_The_file_already_exists, (Object)file.getAbsolutePath());
                final String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                final int[] retVal = new int[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
                        MessageDialog dialog = new MessageDialog(shell, Messages.DownloadRuntimesSecondPage_Question, null, msg, 3, options, 0){

                            protected int getShellStyle() {
                                return super.getShellStyle() | 0x10000000;
                            }
                        };
                        dialog.open();
                        retVal[0] = dialog.getReturnCode();
                    }
                });
                return retVal[0];
            }
        };
        return overwriteQuery;
    }
}

