/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.wizard;

import java.util.List;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.jboss.tools.foundation.core.IURLProvider;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.foundation.ui.xpl.taskwizard.IWizardHandle;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.internal.Messages;

public class DownloadRuntimeLicenseFragment
extends WizardFragment
implements IURLProvider {
    private static final String DOWNLOAD_RUNTIME_SECTION = "downloadRuntimeSection";
    private Button accept;
    private Button decline;
    private Browser browser;
    private DownloadRuntime dlrt;
    private IDialogSettings downloadRuntimeSection = DialogSettings.getOrCreateSection((IDialogSettings)RuntimeUIActivator.getDefault().getDialogSettings(), (String)"downloadRuntimeSection");
    private IWizardHandle handle;
    private Composite wrap;
    Clipboard cb;

    public boolean hasComposite() {
        return true;
    }

    protected void createChildFragments(List<WizardFragment> list) {
    }

    public void enter() {
        DownloadRuntime tmp = this.getDownloadRuntimeFromTaskModel();
        if (tmp != null && !tmp.equals((Object)this.dlrt)) {
            this.dlrt = tmp;
            this.setDownloadRuntime(this.dlrt);
        }
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.cb = new Clipboard(parent.getDisplay());
        this.handle = handle;
        this.getPage().setTitle(Messages.DownloadRuntimeLicensePage_Runtime_License);
        this.getPage().setDescription(Messages.DownloadRuntimeLicensePage_This_license_must_be_accepted);
        Composite contents = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new GridLayout(1, false));
        this.wrap = new Composite(contents, 2048);
        this.wrap.setLayout((Layout)new GridLayout(1, false));
        this.browser = null;
        Control ctrl = new BrowserUtility().createBrowserOrLink(8, this.wrap, BrowserUtility.getPreferredBrowser(), (IURLProvider)this, Messages.DownloadRuntimeLicenseFragment_Please_read_and_accept_the_license_agreement);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 150;
        gd.widthHint = 300;
        if (ctrl instanceof Link) {
            Menu popupMenu = new Menu(ctrl);
            MenuItem refreshItem = new MenuItem(popupMenu, 0);
            refreshItem.setText(Messages.DownloadRuntimeLicenseFragment_Open_in_external_browser);
            CopyToClipboardListener copyListener = new CopyToClipboardListener();
            refreshItem.addSelectionListener((SelectionListener)copyListener);
            MenuItem copyToClipboard = new MenuItem(popupMenu, 0);
            copyToClipboard.setText(Messages.DownloadRuntimeLicenseFragment_Copy_URL_to_clipboard);
            copyToClipboard.addSelectionListener((SelectionListener)new CopyToClipboardListener());
            ctrl.setMenu(popupMenu);
        } else if (ctrl instanceof Browser) {
            this.browser = (Browser)ctrl;
        }
        ctrl.setLayoutData((Object)gd);
        this.wrap.setLayoutData((Object)gd);
        this.accept = new Button(contents, 16);
        this.accept.setText(Messages.DownloadRuntimeLicensePage_I_accept_the_terms);
        AcceptSelectionListener acceptListener = new AcceptSelectionListener();
        this.accept.addSelectionListener((SelectionListener)acceptListener);
        this.decline = new Button(contents, 16);
        this.decline.setText(Messages.DownloadRuntimeLicensePage_I_do_not_accept_the_terms);
        this.decline.setSelection(true);
        this.decline.addSelectionListener((SelectionListener)acceptListener);
        this.setDownloadRuntime(this.getDownloadRuntimeFromTaskModel());
        return contents;
    }

    private void setDownloadRuntime(DownloadRuntime downloadRuntime) {
        if (downloadRuntime != null) {
            if (this.browser != null && downloadRuntime.getLicenceURL() != null && !downloadRuntime.getLicenceURL().isEmpty()) {
                this.browser.setText("<html></html>");
                this.browser.setUrl(downloadRuntime.getLicenceURL());
            } else if (this.browser == null && downloadRuntime.getLicenceURL() != null) {
                downloadRuntime.getLicenceURL().isEmpty();
            }
            this.getPage().setTitle(NLS.bind((String)Messages.DownloadRuntimeLicensePage_Runtime, (Object)downloadRuntime.getName()));
            boolean accepted = this.isAccepted(downloadRuntime);
            if (this.decline != null) {
                this.decline.setSelection(!accepted);
                this.accept.setSelection(accepted);
                this.setComplete(accepted);
            }
        } else if (this.decline != null) {
            this.decline.setSelection(true);
            this.accept.setSelection(false);
            this.setComplete(false);
        }
        this.handle.update();
    }

    public boolean isAccepted(DownloadRuntime downloadRuntime) {
        if (downloadRuntime == null) {
            return false;
        }
        if (downloadRuntime != null && (downloadRuntime.getLicenceURL() == null || downloadRuntime.getLicenceURL().isEmpty())) {
            return true;
        }
        return this.downloadRuntimeSection.getBoolean(downloadRuntime.getId());
    }

    public void finishPage() {
        DownloadRuntime dl = this.getDownloadRuntimeFromTaskModel();
        if (dl != null && this.accept != null && !this.accept.isDisposed()) {
            this.downloadRuntimeSection.put(dl.getId(), this.accept.getSelection());
        }
    }

    private DownloadRuntime getDownloadRuntimeFromTaskModel() {
        return (DownloadRuntime)this.getTaskModel().getObject("dl.runtime.prop");
    }

    public String getUrl() {
        return this.dlrt.getLicenceURL();
    }

    private final class AcceptSelectionListener
    extends SelectionAdapter {
        private AcceptSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            DownloadRuntimeLicenseFragment.this.setComplete(DownloadRuntimeLicenseFragment.this.accept.getSelection());
            DownloadRuntimeLicenseFragment.this.handle.update();
        }
    }

    private final class CopyToClipboardListener
    extends SelectionAdapter {
        private CopyToClipboardListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TextTransfer textTransfer = TextTransfer.getInstance();
            DownloadRuntimeLicenseFragment.this.cb.setContents(new Object[]{DownloadRuntimeLicenseFragment.this.getDownloadRuntimeFromTaskModel().getLicenceURL()}, new Transfer[]{textTransfer});
        }
    }
}

