/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.dialogs;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimePath;
import org.jboss.tools.runtime.core.util.RuntimeInitializerUtil;
import org.jboss.tools.runtime.core.util.RuntimeModelUtil;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.internal.Messages;
import org.jboss.tools.runtime.ui.internal.RuntimeWorkbenchUtils;
import org.jboss.tools.runtime.ui.internal.dialogs.RuntimeCheckboxTreeViewer;

public class SearchRuntimePathDialog
extends ProgressMonitorDialog {
    private Set<RuntimePath> runtimePaths = new HashSet<RuntimePath>();
    private boolean running = true;
    private CheckboxTreeViewer treeViewer;
    private boolean canceled;
    private boolean needRefresh;
    private Label foundRuntimesLabel;
    private Button hideCreatedRuntimes;
    private int heightHint;

    public static SearchRuntimePathDialog launchSearchRuntimePathDialog(Shell shell, final RuntimePath[] runtimePaths, boolean needRefresh, int heightHint) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                RuntimeInitializerUtil.createRuntimeDefinitions((RuntimePath[])runtimePaths, (IProgressMonitor)monitor);
            }
        };
        try {
            HashSet<RuntimePath> set = new HashSet<RuntimePath>(Arrays.asList(runtimePaths));
            SearchRuntimePathDialog dialog = new SearchRuntimePathDialog(shell, set, needRefresh, heightHint);
            dialog.run(true, true, op);
            return dialog;
        }
        catch (InvocationTargetException e1) {
            RuntimeUIActivator.pluginLog().logError((Throwable)e1);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    public SearchRuntimePathDialog(Shell parent, Set<RuntimePath> runtimePaths, boolean needRefresh, int heightHint) {
        super(parent);
        this.setShellStyle(0x10C70 | SearchRuntimePathDialog.getDefaultOrientation());
        this.runtimePaths = runtimePaths;
        this.needRefresh = needRefresh;
        this.heightHint = heightHint;
    }

    private void setMessage(String messageString, boolean force) {
        String string = this.message = messageString == null ? "" : messageString;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        if (force || this.messageLabel.isVisible()) {
            this.messageLabel.setToolTipText(this.message);
            this.messageLabel.setText(SearchRuntimePathDialog.shortenText((String)this.message, (Control)this.messageLabel));
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.SearchRuntimePathDialog_Searching_for_runtimes);
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.minimumHeight = this.convertVerticalDLUsToPixels(this.heightHint);
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.foundRuntimesLabel = new Label(composite, 0);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.foundRuntimesLabel.setLayoutData((Object)gd);
        this.foundRuntimesLabel.setFont(parent.getFont());
        this.foundRuntimesLabel.setText("");
        this.setMessage(Messages.SearchRuntimePathDialog_Searching, false);
        this.createMessageArea(composite);
        this.taskLabel = this.messageLabel;
        this.treeViewer = SearchRuntimePathDialog.createRuntimeViewer(this.runtimePaths, composite, this.heightHint);
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RuntimeDefinition definition;
                definition.setEnabled(!(definition = (RuntimeDefinition)event.getElement()).isEnabled());
                SearchRuntimePathDialog.this.getButton(0).setEnabled(SearchRuntimePathDialog.this.anyDefinitionsChecked());
            }
        });
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.treeViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 4;
            }
        };
        TreeViewerEditor.create((TreeViewer)this.treeViewer, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        this.subTaskLabel = new Label(parent, 16448);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        gd.heightHint = 0;
        this.subTaskLabel.setLayoutData((Object)gd);
        this.subTaskLabel.setFont(parent.getFont());
        this.progressIndicator = new ProgressIndicator(parent);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        gd.heightHint = 0;
        this.progressIndicator.setLayoutData((Object)gd);
        this.hideCreatedRuntimes = new Button(parent, 32);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.hideCreatedRuntimes.setLayoutData((Object)gd);
        this.hideCreatedRuntimes.setText(Messages.SearchRuntimePathDialog_Hide_already_created_runtimes);
        this.hideCreatedRuntimes.setSelection(true);
        this.hideCreatedRuntimes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchRuntimePathDialog.this.refresh(null);
            }
        });
        return parent;
    }

    public static RuntimeCheckboxTreeViewer createRuntimeViewer(Set<RuntimePath> runtimePaths2, Composite composite, int heightHint) {
        return new RuntimeCheckboxTreeViewer(composite, runtimePaths2, heightHint);
    }

    private boolean anyDefinitionsChecked() {
        boolean enableOk = false;
        List<RuntimeDefinition> runtimeDefinitions = this.getRuntimeDefinitions(true);
        for (RuntimeDefinition runtimeDefinition : runtimeDefinitions) {
            if (runtimeDefinition.isEnabled()) {
                enableOk = true;
            } else {
                for (RuntimeDefinition includedDefinition : runtimeDefinition.getIncludedRuntimeDefinitions()) {
                    if (!includedDefinition.isEnabled()) continue;
                    enableOk = true;
                    break;
                }
            }
            if (enableOk) break;
        }
        return enableOk;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        okButton.setEnabled(false);
        this.createButton(parent, 18, Messages.SearchRuntimePathDialog_Select_All);
        this.createButton(parent, 19, Messages.SearchRuntimePathDialog_Deselect_All);
        this.createCancelButton(parent);
    }

    private Button createButton(Composite parent, int id, String label) {
        Button button = this.createButton(parent, id, label, false);
        button.setEnabled(false);
        return button;
    }

    protected void createCancelButton(Composite parent) {
        this.cancel = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        if (this.arrowCursor == null) {
            this.arrowCursor = new Cursor((Device)this.cancel.getDisplay(), 0);
        }
        this.cancel.setCursor(this.arrowCursor);
        this.setOperationCancelButtonEnabled(this.enableCancelButton);
    }

    protected void cancelPressed() {
        this.getProgressMonitor().setCanceled(true);
        if (this.running) {
            this.canceled = true;
        } else {
            this.setReturnCode(1);
            this.close();
        }
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (18 == buttonId) {
            this.selectAllPressed();
        } else if (19 == buttonId) {
            this.deselectAllPressed();
        }
    }

    private void deselectAllPressed() {
        this.setChecked(false);
        this.getButton(0).setEnabled(this.anyDefinitionsChecked());
    }

    private void setChecked(boolean checked) {
        List<RuntimeDefinition> runtimeDefinitions = this.getRuntimeDefinitions(this.hideCreatedRuntimes.getSelection());
        for (RuntimeDefinition definition : runtimeDefinitions) {
            this.treeViewer.setChecked((Object)definition, checked);
            definition.setEnabled(checked);
            for (RuntimeDefinition included : definition.getIncludedRuntimeDefinitions()) {
                this.treeViewer.setChecked((Object)included, checked);
                included.setEnabled(checked);
            }
        }
        this.treeViewer.refresh();
    }

    private void selectAllPressed() {
        this.setChecked(true);
        this.getButton(0).setEnabled(this.anyDefinitionsChecked());
    }

    private static boolean runtimeExists(RuntimeDefinition runtimeDefinition) {
        return RuntimeModelUtil.verifyRuntimeDefinitionCreated((RuntimeDefinition)runtimeDefinition, (boolean)false);
    }

    private void refresh(String message) {
        TreeItem[] treeItems;
        this.running = false;
        this.treeViewer.setInput(null);
        List<RuntimeDefinition> runtimeDefinitions = this.getRuntimeDefinitions(this.hideCreatedRuntimes.getSelection());
        this.treeViewer.setInput(runtimeDefinitions);
        for (RuntimeDefinition definition : runtimeDefinitions) {
            this.treeViewer.setChecked((Object)definition, definition.isEnabled());
            for (RuntimeDefinition included : definition.getIncludedRuntimeDefinitions()) {
                this.treeViewer.setChecked((Object)included, included.isEnabled());
            }
        }
        TreeItem[] treeItemArray = treeItems = this.treeViewer.getTree().getItems();
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimeDefinition runtimeDefinition;
            boolean exists;
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            if (data instanceof RuntimeDefinition && (exists = SearchRuntimePathDialog.runtimeExists(runtimeDefinition = (RuntimeDefinition)data))) {
                treeItem.setBackground(Display.getCurrent().getSystemColor(15));
                this.treeViewer.setChecked((Object)runtimeDefinition, runtimeDefinition.isEnabled());
            }
            ++n2;
        }
        if (message != null) {
            this.setMessage(message, false);
        }
    }

    protected void okPressed() {
        this.getShell().setCursor(Display.getCurrent().getSystemCursor(1));
        final List<RuntimeDefinition> definitions = this.getEnabledRuntimeDefinitions();
        this.getShell().setCursor(null);
        this.setReturnCode(0);
        this.close();
        final boolean needRefresh = this.needRefresh;
        new Job(Messages.SearchRuntimePathDialog_Initializing_runtimes){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus ret = RuntimeInitializerUtil.initializeRuntimes((List)definitions);
                if (needRefresh) {
                    RuntimeWorkbenchUtils.refreshPreferencePage(SearchRuntimePathDialog.this.getShell());
                }
                return ret;
            }
        }.schedule();
    }

    protected void finishedRun() {
        String foundRuntimes;
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return;
        }
        this.decrementNestingDepth();
        this.getShell().setCursor(null);
        int count = this.getRuntimeDefinitions(true).size();
        if (count == 0) {
            this.hideCreatedRuntimes.setSelection(false);
        }
        if (this.canceled) {
            this.refresh(Messages.SearchRuntimePathDialog_Searching_runtimes_is_canceled);
        } else {
            this.refresh(Messages.SearchRuntimePathDialog_Searching_runtimes_is_finished);
            RuntimeModelUtil.updateTimestamps((RuntimePath[])this.runtimePaths.toArray(new RuntimePath[this.runtimePaths.size()]));
        }
        if (count == 0) {
            foundRuntimes = Messages.SearchRuntimePathDialog_No_runtime_found;
            this.getButton(0).setEnabled(false);
        } else {
            foundRuntimes = count == 1 ? NLS.bind((String)Messages.SearchRuntimePathDialog_New_runtime_found, (Object)count) : NLS.bind((String)Messages.SearchRuntimePathDialog_New_runtimes_found, (Object)count);
            this.getButton(0).setEnabled(true);
            this.getButton(18).setEnabled(true);
            this.getButton(19).setEnabled(true);
        }
        this.foundRuntimesLabel.setText(foundRuntimes);
    }

    protected Image getImage() {
        return null;
    }

    protected Control createMessageArea(Composite composite) {
        if (this.message != null) {
            this.messageLabel = new Label(composite, this.getMessageLabelStyle());
            this.messageLabel.setText(this.message);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)this.messageLabel);
        }
        return composite;
    }

    private List<RuntimeDefinition> getEnabledRuntimeDefinitions() {
        List<RuntimeDefinition> all = this.getRuntimeDefinitions(true);
        Iterator<RuntimeDefinition> i = all.iterator();
        while (i.hasNext()) {
            RuntimeDefinition rd = i.next();
            if (rd.isEnabled()) continue;
            boolean add = false;
            for (RuntimeDefinition ird : rd.getIncludedRuntimeDefinitions()) {
                if (!ird.isEnabled()) continue;
                add = true;
                break;
            }
            if (add) continue;
            i.remove();
        }
        return all;
    }

    private List<RuntimeDefinition> getRuntimeDefinitions(boolean hideCreatedRuntimes) {
        ArrayList<RuntimeDefinition> runtimeDefinitions = new ArrayList<RuntimeDefinition>();
        List allDefinitions = RuntimeModelUtil.getAllDefinitions((RuntimePath[])this.runtimePaths.toArray(new RuntimePath[0]));
        for (RuntimePath runtimePath : this.runtimePaths) {
            List pathDefinitions = RuntimeModelUtil.getAllDefinitions((RuntimePath)runtimePath);
            for (RuntimeDefinition runtimeDefinition : pathDefinitions) {
                if (RuntimeModelUtil.verifyRuntimeDefinitionCreated((RuntimeDefinition)runtimeDefinition)) continue;
                String name = runtimeDefinition.getName();
                int i = 2;
                while (this.runtimeDefinitionExists(runtimeDefinition, allDefinitions)) {
                    runtimeDefinition.setName(String.valueOf(name) + " (" + i++ + ")");
                }
            }
        }
        for (RuntimePath runtimePath : this.runtimePaths) {
            RuntimeDefinition[] runtimeDefinitionArray = runtimePath.getRuntimeDefinitions();
            int n = runtimeDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                RuntimeDefinition runtimeDefinition = runtimeDefinitionArray[n2];
                if (!runtimeDefinitions.contains(runtimeDefinition)) {
                    if (!hideCreatedRuntimes) {
                        runtimeDefinitions.add(runtimeDefinition);
                    } else if (!RuntimeModelUtil.verifyRuntimeDefinitionCreated((RuntimeDefinition)runtimeDefinition)) {
                        runtimeDefinitions.add(runtimeDefinition);
                    }
                }
                ++n2;
            }
        }
        Collections.sort(runtimeDefinitions, new Comparator<RuntimeDefinition>(){

            @Override
            public int compare(RuntimeDefinition o1, RuntimeDefinition o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null || o1.getName() == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        return runtimeDefinitions;
    }

    private boolean runtimeDefinitionExists(RuntimeDefinition runtimeDefinition, List<RuntimeDefinition> allRuntimeDefinitions) {
        String name = runtimeDefinition.getName();
        File location = runtimeDefinition.getLocation();
        String type = runtimeDefinition.getType();
        if (name == null || location == null || type == null) {
            return false;
        }
        String path = location.getAbsolutePath();
        if (path == null) {
            return false;
        }
        for (RuntimeDefinition definition : allRuntimeDefinitions) {
            String dPath;
            File loc;
            if (!name.equals(definition.getName()) || !type.equals(definition.getType()) || (loc = definition.getLocation()) == null || (dPath = loc.getAbsolutePath()) == null || path.equals(dPath)) continue;
            return true;
        }
        return false;
    }
}

