/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.ui.internal;

import java.io.File;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyTextCommand;
import org.jboss.tools.openshift.cdk.server.ui.internal.util.FormDataUtility;

public class LocationSection
extends ServerEditorSection {
    protected ServerAttributeHelper helper;
    private SelectionListener browseListener;
    private ModifyListener locationListener;
    private Text location;
    private Button browse;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        this.createUI(parent);
        this.setDefaultValues();
        this.addListeners();
    }

    protected void createUI(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 258);
        section.setText("CDK Details");
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new FormLayout());
        Label l = toolkit.createLabel(composite, "Vagrantfile Location: ");
        this.location = toolkit.createText(composite, "");
        this.browse = toolkit.createButton(composite, "Browse...", 8);
        FormDataUtility fdu = new FormDataUtility();
        l.setLayoutData((Object)fdu.createFormData(0, 5, null, 0, 0, 5, null, 0));
        FormData locationData = fdu.createFormData(0, 5, null, 0, l, 5, this.browse, -5);
        locationData.width = 150;
        this.location.setLayoutData((Object)locationData);
        this.browse.setLayoutData((Object)fdu.createFormData(0, 5, null, 0, null, 0, 100, -5));
        section.setClient((Control)composite);
    }

    protected void setDefaultValues() {
        String s = this.server.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null);
        this.location.setText(s == null ? "" : s);
    }

    protected void addListeners() {
        this.browseListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LocationSection.this.browseHomeDirClicked();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.browse.addSelectionListener(this.browseListener);
        this.locationListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocationSection.this.execute((IUndoableOperation)new SetLocationPropertyCommand(LocationSection.this.server));
            }
        };
        this.location.addModifyListener(this.locationListener);
    }

    protected void browseHomeDirClicked() {
        String newHomeVal;
        File directory;
        File file;
        File file2 = file = this.location.getText() == null ? null : new File(this.location.getText());
        if (file != null && !file.exists()) {
            file = null;
        }
        if ((directory = LocationSection.getDirectory(file, this.location.getShell())) != null && (newHomeVal = directory.getAbsolutePath()) != null && !newHomeVal.equals(this.location.getText())) {
            this.location.setText(newHomeVal);
        }
    }

    protected static File getDirectory(File startingDirectory, Shell shell) {
        String dir;
        DirectoryDialog fileDialog = new DirectoryDialog(shell, 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    public class SetLocationPropertyCommand
    extends ServerWorkingCopyPropertyTextCommand {
        public SetLocationPropertyCommand(IServerWorkingCopy server) {
            super(server, "Modify Vagrantfile Location", LocationSection.this.location, LocationSection.this.location.getText(), "org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", LocationSection.this.locationListener);
        }
    }
}

