/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ADBInfo;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKDockerUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKOpenshiftUtility;

public class ConfigureDependentFrameworksListener
extends UnitedServerListener {
    public void serverChanged(final ServerEvent event) {
        if (ConfigureDependentFrameworksListener.serverSwitchesToState((ServerEvent)event, (int)2) && this.canHandleServer(event.getServer())) {
            new Thread("Loading ADBInfo to configure dependent frameworks"){

                @Override
                public void run() {
                    if (ConfigureDependentFrameworksListener.this.canHandleServer(event.getServer())) {
                        ConfigureDependentFrameworksListener.this.launchChange(event.getServer());
                    }
                }
            }.start();
        }
    }

    private void launchChange(IServer server) {
        ADBInfo adb = ADBInfo.loadADBInfo(server);
        ControllableServerBehavior beh = (ControllableServerBehavior)server.loadAdapter(ControllableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor());
        if (beh != null) {
            beh.putSharedData("cdk.sharedinfo.adbInfo", (Object)adb);
        }
        if (adb != null) {
            this.configureOpenshift(server, adb);
            this.configureDocker(server, adb);
        }
    }

    public boolean canHandleServer(IServer server) {
        return server.getServerType().getId().equals("org.jboss.tools.openshift.cdk.server.type");
    }

    private void configureDocker(IServer server, ADBInfo adb) {
        try {
            CDKDockerUtility util = new CDKDockerUtility();
            if (!util.dockerConnectionExists(adb)) {
                util.createDockerConnection(server, adb);
            }
        }
        catch (DockerException de) {
            CDKCoreActivator.pluginLog().logError("Error while creating docker connection for server " + server.getName(), (Throwable)de);
        }
    }

    private void configureOpenshift(IServer server, ADBInfo adb) {
        CDKOpenshiftUtility util = new CDKOpenshiftUtility();
        if (util.findExistingOpenshiftConnection(server, adb) == null) {
            util.createOpenshiftConnection(server, adb);
        }
    }
}

