/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;

public class CDKServerUtility {
    public static Properties getDotCDK(IServer server) {
        File dotcdk;
        String cdkFolder = server.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null);
        if (cdkFolder != null && new File(cdkFolder).exists() && (dotcdk = new File(cdkFolder, ".cdk")).exists()) {
            try {
                Properties props = new Properties();
                props.load(new FileInputStream(dotcdk));
                return props;
            }
            catch (IOException ioe) {
                CDKCoreActivator.pluginLog().logError("Error loading properties from .cdk file " + dotcdk.getAbsolutePath(), (Throwable)ioe);
            }
        }
        return new Properties();
    }

    public static File getWorkingDirectory(IServer s) {
        String str = s.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null);
        if (str != null && new File(str).exists()) {
            return new File(str);
        }
        return null;
    }
}

