/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import java.util.Collection;
import java.util.Properties;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ADBInfo;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKServerUtility;
import org.jboss.tools.openshift.common.core.connection.ConnectionType;
import org.jboss.tools.openshift.common.core.connection.ConnectionsFactoryTracker;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionFactory;
import org.jboss.tools.openshift.core.connection.Connection;

public class CDKOpenshiftUtility {
    private static String DOTCDK_AUTH_SCHEME = "openshift.auth.scheme";
    private static String DOTCDK_AUTH_USERNAME = "openshift.auth.username";

    public IConnection findExistingOpenshiftConnection(IServer server, ADBInfo adb) {
        new CDKServerUtility();
        Properties dotcdkProps = CDKServerUtility.getDotCDK(server);
        if (dotcdkProps.containsKey(DOTCDK_AUTH_SCHEME)) {
            dotcdkProps.getProperty(DOTCDK_AUTH_SCHEME);
        }
        if (dotcdkProps.containsKey(DOTCDK_AUTH_USERNAME)) {
            dotcdkProps.getProperty(DOTCDK_AUTH_USERNAME);
        }
        String soughtHost = String.valueOf(adb.openshiftHost) + ":" + adb.openshiftPort;
        Collection connections = ConnectionsRegistrySingleton.getInstance().getAll();
        for (IConnection c : connections) {
            String host;
            if (c.getType() != ConnectionType.Kubernetes || !(host = c.getHost()).equals(soughtHost)) continue;
            return c;
        }
        return null;
    }

    public IConnection createOpenshiftConnection(IServer server, ADBInfo adb) {
        new CDKServerUtility();
        Properties dotcdkProps = CDKServerUtility.getDotCDK(server);
        String authScheme = dotcdkProps.containsKey(DOTCDK_AUTH_SCHEME) ? dotcdkProps.getProperty(DOTCDK_AUTH_SCHEME) : "Basic";
        String username = dotcdkProps.containsKey(DOTCDK_AUTH_USERNAME) ? dotcdkProps.getProperty(DOTCDK_AUTH_USERNAME) : "test-admin";
        String soughtHost = String.valueOf(adb.openshiftHost) + ":" + adb.openshiftPort;
        ConnectionsFactoryTracker connectionsFactory = new ConnectionsFactoryTracker();
        connectionsFactory.open();
        IConnectionFactory factory = connectionsFactory.getById("org.jboss.tools.openshift.core.ConnectionFactory");
        IConnection con = factory.create(soughtHost);
        ((Connection)con).setAuthScheme(authScheme);
        ((Connection)con).setUsername(username);
        ConnectionsRegistrySingleton.getInstance().add(con);
        return con;
    }
}

