/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ADBInfo;

public class CDKDockerUtility {
    public String getNextName(IServer server, DockerConnectionManager mgr) {
        String nameBase;
        IDockerConnection[] cons = mgr.getConnections();
        List names = Arrays.stream(cons).map(IDockerConnection::getName).collect(Collectors.toList());
        String name = nameBase = server.getName();
        int count = 0;
        boolean done = false;
        while (!done) {
            if (names.contains(name)) {
                name = String.valueOf(nameBase) + " (" + ++count + ")";
                continue;
            }
            done = true;
        }
        return name;
    }

    public IDockerConnection findDockerConnection(ADBInfo adb) {
        DockerConnectionManager mgr = DockerConnectionManager.getInstance();
        String dockerHost = adb.env.get("DOCKER_HOST");
        IDockerConnection[] cons = mgr.getConnections();
        String httpHost = dockerHost.replace("tcp://", "http://");
        String httpsHost = dockerHost.replace("tcp://", "https://");
        int i = 0;
        while (i < cons.length) {
            if (cons[i].getUri().equals(dockerHost) || cons[i].getUri().equals(httpHost) || cons[i].getUri().equals(httpsHost)) {
                return cons[i];
            }
            ++i;
        }
        return null;
    }

    public boolean dockerConnectionExists(ADBInfo adb) {
        return this.findDockerConnection(adb) != null;
    }

    public void createDockerConnection(IServer server, ADBInfo adb) throws DockerException {
        boolean tlsVerify;
        DockerConnectionManager mgr = DockerConnectionManager.getInstance();
        String dockerHost = adb.env.get("DOCKER_HOST");
        DockerConnection.Builder tcpConnectionBuilder = new DockerConnection.Builder().name(this.getNextName(server, mgr)).tcpHost(dockerHost);
        String tlsVerifyString = adb.env.get("DOCKER_TLS_VERIFY");
        boolean bl = tlsVerify = Integer.parseInt(tlsVerifyString) != 0;
        if (tlsVerify) {
            String tlsCertPath = adb.env.get("DOCKER_CERT_PATH");
            tcpConnectionBuilder.tcpCertPath(tlsCertPath);
        }
        DockerConnection con = tcpConnectionBuilder.build();
        mgr.getConnections();
        mgr.addConnection((IDockerConnection)con);
    }
}

