/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKConstantUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.VagrantLaunchUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKServerUtility;

public class ADBInfo {
    public static final String SHARED_INFO_KEY = "cdk.sharedinfo.adbInfo";
    int openshiftPort = 8443;
    String openshiftHost = "https://10.1.2.2";
    HashMap<String, String> env;

    public ADBInfo(HashMap<String, String> env) throws URISyntaxException {
        this.env = env;
        String dockerHost = env.get("DOCKER_HOST");
        if (dockerHost != null) {
            URI url = new URI(dockerHost);
            String h = url.getHost();
            this.openshiftHost = "https://" + h;
        }
    }

    public static ADBInfo loadADBInfo(IServer server) {
        String[] args = new String[]{"adbinfo", "--no-color"};
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        String vagrantcmdloc = CDKConstantUtility.getVagrantLocation(server);
        CDKServer cdkServer = (CDKServer)((Object)server.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        boolean passCredentials = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.passCredentials", false);
        if (passCredentials) {
            String userKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.user", "SUB_USERNAME");
            String passKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.pass", "SUB_PASSWORD");
            env.put(userKey, cdkServer.getUsername());
            env.put(passKey, cdkServer.getPassword());
        }
        HashMap<String, String> adbEnv = new HashMap<String, String>();
        try {
            String[] lines = VagrantLaunchUtility.call(vagrantcmdloc, args, CDKServerUtility.getWorkingDirectory(server), env);
            String setEnvVarCommand = Platform.getOS().equals("win32") ? "setx " : "export ";
            String setEnvVarDelim = Platform.getOS().equals("win32") ? " " : "=";
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String oneAppend = stringArray[n2];
                String[] allAppends = oneAppend.split("\n");
                int i = 0;
                while (i < allAppends.length) {
                    String lineRemainder;
                    int eq;
                    if (allAppends[i].trim().startsWith(setEnvVarCommand) && (eq = (lineRemainder = allAppends[i].trim().substring(setEnvVarCommand.length())).indexOf(setEnvVarDelim)) != -1) {
                        String k = lineRemainder.substring(0, eq);
                        String v = lineRemainder.substring(eq + 1);
                        adbEnv.put(k, v);
                    }
                    ++i;
                }
                ++n2;
            }
            return new ADBInfo(adbEnv);
        }
        catch (URISyntaxException urise) {
            CDKCoreActivator.pluginLog().logError("Environment variable DOCKER_HOST is not a valid uri:  " + env.get("DOCKER_HOST"), (Throwable)urise);
        }
        catch (IOException | TimeoutException ce) {
            CDKCoreActivator.pluginLog().logError("Unable to successfully complete a call to vagrant adbinfo. ", (Throwable)ce);
        }
        return null;
    }
}

