/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.detection;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.util.ServerNamingUtility;
import org.jboss.tools.foundation.core.credentials.CredentialService;
import org.jboss.tools.foundation.core.credentials.ICredentialDomain;
import org.jboss.tools.runtime.core.model.AbstractRuntimeDetectorDelegate;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;

public class CDKRuntimeDetector
extends AbstractRuntimeDetectorDelegate {
    public static final String CDK_RUNTIME_TYPE = "CDK";

    public RuntimeDefinition getRuntimeDefinition(File root, IProgressMonitor monitor) {
        if (this.validate(root)) {
            return new RuntimeDefinition(root.getName(), "2.0", CDK_RUNTIME_TYPE, root);
        }
        return null;
    }

    public boolean initializeRuntime(RuntimeDefinition runtimeDefinition) throws CoreException {
        if (!this.exists(runtimeDefinition) && this.validate(runtimeDefinition.getLocation())) {
            IServerType st = ServerCore.findServerType((String)"org.jboss.tools.openshift.cdk.server.type");
            String possibleId = String.valueOf(runtimeDefinition.getLocation().getName()) + " CDK Server";
            String suffixed = ServerNamingUtility.getDefaultServerName((String)possibleId);
            try {
                ICredentialDomain domain;
                String val;
                IServerWorkingCopy wc = st.createServer(suffixed, null, (IProgressMonitor)new NullProgressMonitor());
                String folder = runtimeDefinition.getLocation().getAbsolutePath();
                File cdkFile = new File(folder, ".cdk");
                Properties props = new Properties();
                if (cdkFile.exists()) {
                    try {
                        props.load(new FileInputStream(cdkFile));
                    }
                    catch (IOException iOException) {}
                }
                if ((val = props.getProperty("rhel.subscription.username")) != null && !(domain = CredentialService.getCredentialModel().getDomain("access.redhat.com")).userExists(val)) {
                    CredentialService.getCredentialModel().addPromptedCredentials(domain, val);
                    CredentialService.getCredentialModel().saveModel();
                }
                wc.setAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", folder);
                wc.setAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.username", val);
                wc.setName(suffixed);
                wc.save(true, (IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public boolean exists(RuntimeDefinition runtimeDefinition) {
        if (this.validate(runtimeDefinition.getLocation())) {
            IServer[] all = ServerCore.getServers();
            int i = 0;
            while (i < all.length) {
                String s;
                if (all[i].getServerType().getId().equals("org.jboss.tools.openshift.cdk.server.type") && (s = all[i].getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null)) != null && new File(s).equals(runtimeDefinition.getLocation())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean validate(File root) {
        return new File(root, "Vagrantfile").exists() && new File(root, ".cdk").exists();
    }
}

