/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.ExternalLaunchUtil;
import org.jboss.tools.openshift.internal.common.core.util.ThreadUtils;

public class VagrantLaunchUtility {
    public ILaunchConfigurationWorkingCopy createExternalToolsLaunchConfig(IServer s, String args, String launchConfigName) throws CoreException {
        return this.setupLaunch(s, args, launchConfigName, s.getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor()));
    }

    public ILaunchConfigurationWorkingCopy setupLaunch(IServer s, String args, String launchConfigName, ILaunchConfiguration startupConfig) throws CoreException {
        CDKServer cdkServer = (CDKServer)((Object)s.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        ILaunchConfigurationWorkingCopy wc = this.findLaunchConfig(s, launchConfigName);
        wc.setAttributes(startupConfig.getAttributes());
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
        boolean passCredentials = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.passCredentials", false);
        if (passCredentials) {
            String userName;
            HashMap existingEnvironment = startupConfig.getAttribute("org.eclipse.debug.core.environmentVariables", null);
            if (existingEnvironment == null) {
                existingEnvironment = new HashMap();
            }
            if ((userName = cdkServer.getUsername()) == null) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "The credentials for " + s.getName() + " are invalid. No username found. Please open your server editor " + "and set your access.redhat.com credentials."));
            }
            HashMap<String, String> env = new HashMap<String, String>(existingEnvironment);
            String passKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.pass", "SUB_PASSWORD");
            String pass = cdkServer.getPassword();
            if (pass == null) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "The credentials for " + s.getName() + " are invalid. No password found for username " + cdkServer.getUsername() + " for the access.redhat.com domain. Please open your server editor " + "set your access.redhat.com credentials."));
            }
            if (passKey != null && pass != null) {
                env.put(passKey, pass);
            }
            wc.setAttribute("org.eclipse.debug.core.environmentVariables", env);
        } else {
            wc.setAttribute("org.eclipse.debug.core.environmentVariables", startupConfig.getAttribute("org.eclipse.debug.core.environmentVariables", null));
        }
        return wc;
    }

    private ILaunchConfigurationWorkingCopy findLaunchConfig(IServer s, String launchName) throws CoreException {
        return ExternalLaunchUtil.findExternalToolsLaunchConfig(s, launchName);
    }

    public static String[] convertEnvironment(Map<String, String> env) {
        if (env == null || env.size() == 0) {
            return null;
        }
        HashMap<String, String> original = new HashMap<String, String>(System.getenv());
        original.putAll(env);
        ArrayList<String> ret = new ArrayList<String>();
        Iterator it = original.keySet().iterator();
        String working = null;
        while (it.hasNext()) {
            working = (String)it.next();
            ret.add(String.valueOf(working) + "=" + (String)original.get(working));
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static String[] call(String rootCommand, String[] args, File vagrantDir, Map<String, String> env) throws IOException, TimeoutException {
        return VagrantLaunchUtility.call(rootCommand, args, vagrantDir, env, 30000);
    }

    public static String[] call(String rootCommand, String[] args, File vagrantDir, Map<String, String> env, int timeout) throws IOException, TimeoutException {
        String[] envp = env == null ? null : VagrantLaunchUtility.convertEnvironment(env);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(rootCommand);
        cmd.addAll(Arrays.asList(args));
        final Process p = Runtime.getRuntime().exec(cmd.toArray(new String[0]), envp, vagrantDir);
        InputStream errStream = p.getErrorStream();
        InputStream inStream = p.getInputStream();
        Integer exitCode = (Integer)ThreadUtils.runWithTimeout((long)timeout, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return p.waitFor();
            }
        });
        List<String> inLines = VagrantLaunchUtility.readStream(inStream);
        List<String> errLines = VagrantLaunchUtility.readStream(errStream);
        if (exitCode == null) {
            p.destroyForcibly();
            throw new TimeoutException(VagrantLaunchUtility.getTimeoutError(inLines, errLines));
        }
        return inLines.toArray(new String[inLines.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> readStream(InputStream inStream) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                BufferedInputStream is = new BufferedInputStream(inStream);
                try {
                    try (Scanner inScanner = new Scanner(is);){
                        while (inScanner.hasNextLine()) {
                            lines.add(inScanner.nextLine());
                        }
                    }
                    if (is == null) return lines;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return lines;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return lines;
    }

    private static String getTimeoutError(List<String> output, List<String> err) {
        StringBuilder msg = new StringBuilder();
        msg.append("Process output:\n");
        output.forEach(line -> {
            StringBuilder stringBuilder2 = msg.append("   ").append((String)line);
        });
        err.forEach(line -> {
            StringBuilder stringBuilder2 = msg.append("   ").append((String)line);
        });
        return msg.toString();
    }
}

