/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller2;
import org.jboss.ide.eclipse.as.core.server.IServerStatePollerType;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKConstantUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKConstants;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.VagrantLaunchUtility;

public class VagrantPoller
implements IServerStatePoller2 {
    private IServer server;
    private boolean canceled;
    private boolean done;
    private boolean state;
    private boolean expectedState;
    private IServerStatePoller.PollingException aborted = null;

    public IServer getServer() {
        return this.server;
    }

    public void beginPolling(IServer server, boolean expectedState) throws IServerStatePoller.PollingException {
        this.server = server;
        this.done = false;
        this.canceled = false;
        this.expectedState = expectedState;
        this.state = !expectedState;
        this.launchThread();
    }

    protected void launchThread() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                VagrantPoller.this.pollerRun();
            }
        }, "Vagrant Poller");
        t.start();
    }

    private synchronized void setStateInternal(boolean done, boolean state) {
        this.done = done;
        this.state = state;
    }

    private void pollerRun() {
        this.setStateInternal(false, this.state);
        CDKServer cdkServer = (CDKServer)((Object)this.server.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        String pass = cdkServer.getPassword();
        while (this.aborted == null && !this.canceled && !this.done) {
            boolean completeDown;
            int status = this.onePing(this.server, pass);
            boolean completeUp = status == 0 && this.expectedState;
            boolean bl = completeDown = status == 4 && !this.expectedState;
            if (completeUp || completeDown) {
                this.setStateInternal(true, this.expectedState);
            }
            try {
                Thread.sleep(700L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized boolean isComplete() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        return this.done;
    }

    public synchronized boolean getState() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        return this.state;
    }

    public void cleanup() {
    }

    public synchronized void cancel(int type) {
        this.canceled = true;
    }

    public int getTimeoutBehavior() {
        return 2;
    }

    public List<String> getRequiredProperties() {
        return null;
    }

    public IStatus getCurrentStateSynchronous(IServer server) {
        int b = this.onePing(server);
        Status s = b == 0 ? new Status(0, "org.jboss.tools.openshift.cdk.server.core", "Vagrant Instance is Up") : (b == 4 ? new Status(4, "org.jboss.tools.openshift.cdk.server.core", "Vagrant Instance is shutoff") : new Status(1, "org.jboss.tools.openshift.cdk.server.core", "Vagrant Instance is indeterminate"));
        return s;
    }

    private File getWorkingDirectory(IServer s) throws IServerStatePoller.PollingException {
        String str = s.getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.FOLDER", null);
        if (str != null && new File(str).exists()) {
            return new File(str);
        }
        throw new IServerStatePoller.PollingException("Working Directory not found: " + str);
    }

    private int onePing(IServer server) {
        CDKServer cdkServer = (CDKServer)((Object)server.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        return this.onePing(server, cdkServer.getPassword());
    }

    private int onePing(IServer server, String password) {
        String[] args = new String[]{"status", "--machine-readable", "--no-color"};
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        String vagrantcmdloc = CDKConstantUtility.getVagrantLocation(server);
        CDKServer cdkServer = (CDKServer)((Object)server.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        boolean passCredentials = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.passCredentials", false);
        if (passCredentials) {
            String userKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.user", "SUB_USERNAME");
            String passKey = cdkServer.getServer().getAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.env.pass", "SUB_PASSWORD");
            env.put(userKey, cdkServer.getUsername());
            env.put(passKey, password);
        }
        try {
            String[] lines = VagrantLaunchUtility.call(vagrantcmdloc, args, this.getWorkingDirectory(server), env);
            return this.parseOutput(lines);
        }
        catch (IServerStatePoller.PollingException pe) {
            this.aborted = pe;
        }
        catch (TimeoutException te) {
            this.aborted = new IServerStatePoller.PollingException(te.getMessage(), (Throwable)te);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return 1;
    }

    private int parseOutput(String[] lines) {
        Collection<VagrantStatus> stats;
        HashMap<String, VagrantStatus> status = new HashMap<String, VagrantStatus>();
        if (lines != null && lines.length > 0) {
            int i = 0;
            while (i < lines.length) {
                String[] csv = lines[i].split(",");
                String cfr_ignored_0 = csv[0];
                String vmId = csv[1];
                if (vmId != null && !vmId.isEmpty()) {
                    VagrantStatus vs = (VagrantStatus)status.get(vmId);
                    if (vs == null) {
                        vs = new VagrantStatus(vmId);
                        status.put(vmId, vs);
                    }
                    String k = csv[2];
                    String v = csv[3];
                    if (k != null) {
                        vs.setProperty(k, v);
                    }
                } else {
                    return 1;
                }
                ++i;
            }
        }
        if ((stats = status.values()).size() == 0) {
            return 4;
        }
        if (this.allRunning(stats)) {
            return 0;
        }
        if (this.allStopped(stats)) {
            return 4;
        }
        return 1;
    }

    private boolean allRunning(Collection<VagrantStatus> stats) {
        List<String> on = Arrays.asList(this.getValidRunningStates());
        Iterator<VagrantStatus> i = stats.iterator();
        while (i.hasNext()) {
            if (on.contains(i.next().getState())) continue;
            return false;
        }
        return true;
    }

    private String[] getValidRunningStates() {
        return new String[]{"running"};
    }

    private String[] getValidStoppedStates() {
        return new String[]{"shutoff", "poweroff"};
    }

    private boolean allStopped(Collection<VagrantStatus> stats) {
        List<String> off = Arrays.asList(this.getValidStoppedStates());
        Iterator<VagrantStatus> i = stats.iterator();
        while (i.hasNext()) {
            if (off.contains(i.next().getState())) continue;
            return false;
        }
        return true;
    }

    public void provideCredentials(Properties credentials) {
    }

    public IServerStatePollerType getPollerType() {
        return null;
    }

    public void setPollerType(IServerStatePollerType type) {
    }

    private class VagrantStatus
    implements CDKConstants {
        private HashMap<String, String> kv;
        private String id;

        public VagrantStatus(String vmId) {
            this.id = vmId;
            this.kv = new HashMap();
        }

        public void setProperty(String k, String v) {
            this.kv.put(k, v);
        }

        public String getState() {
            return this.kv.get("state");
        }
    }
}

