/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.central.JBossCentralActivator;

public class ImageUtil {
    public static Image createImageFromUrl(final Device device, URL iconUrl) {
        if (!iconUrl.getProtocol().equals("jar")) {
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)iconUrl);
            return descriptor.createImage();
        }
        final Image[] image = new Image[1];
        try {
            new UrlStreamJarProvider(iconUrl).readStream(new StreamHandler(){

                @Override
                public void handle(InputStream inputStream) {
                    image[0] = new Image(device, inputStream);
                }
            });
        }
        catch (Exception e) {
            JBossCentralActivator.log(e);
        }
        return image[0];
    }

    public static String getImageAsLocalUrl(String url) throws CoreException {
        UrlStreamProvider streamProvider = null;
        try {
            if (url.startsWith("jar:")) {
                streamProvider = new UrlStreamJarProvider(url);
            } else if (url.startsWith("bundleentry:")) {
                streamProvider = new UrlStreamDefaultProvider(url);
            }
        }
        catch (MalformedURLException e) {
            ImageUtil.throwCoreException("Error reading " + url, e);
        }
        if (streamProvider == null) {
            return url;
        }
        final Path localFile = ImageUtil.getLocalImage(url);
        if (Files.notExists(localFile, new LinkOption[0])) {
            streamProvider.readStream(new StreamHandler(){

                @Override
                public void handle(InputStream stream) throws IOException {
                    Files.createDirectories(localFile.getParent(), new FileAttribute[0]);
                    Files.copy(stream, localFile, new CopyOption[0]);
                }
            });
        }
        return localFile.toUri().toString();
    }

    private static Path getLocalImage(String url) {
        String baseDir = JBossCentralActivator.getDefault().getStateLocation().toOSString();
        String name = url.substring(url.lastIndexOf("/"), url.length());
        String hashedPath = String.valueOf(Math.abs(url.hashCode()));
        return Paths.get(baseDir, "images", hashedPath, name);
    }

    private static void throwCoreException(String msg, Exception e) throws CoreException {
        Status status = new Status(4, "org.jboss.tools.central", msg, (Throwable)e);
        throw new CoreException((IStatus)status);
    }

    private static interface StreamHandler {
        public void handle(InputStream var1) throws IOException;
    }

    private static class UrlStreamDefaultProvider
    extends UrlStreamProvider {
        UrlStreamDefaultProvider(String url) throws MalformedURLException {
            this.setUrl(url);
        }

        @Override
        void readStream(StreamHandler streamHandler) throws CoreException {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream stream = this.url.openStream();){
                    streamHandler.handle(stream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                ImageUtil.throwCoreException("Error extracting " + this.url, e);
            }
        }
    }

    private static class UrlStreamJarProvider
    extends UrlStreamProvider {
        UrlStreamJarProvider(URL url) throws MalformedURLException {
            if (!url.getProtocol().equals("jar")) {
                throw new IllegalArgumentException("Only 'jar:' urls are supported");
            }
            this.url = url;
        }

        UrlStreamJarProvider(String url) throws MalformedURLException {
            if (!url.startsWith("jar")) {
                throw new IllegalArgumentException("Only 'jar:' urls are supported");
            }
            this.setUrl(url);
        }

        @Override
        void readStream(StreamHandler streamHandler) throws CoreException {
            String fileName = this.url.getFile();
            if (fileName.contains("!")) {
                String[] location = fileName.split("!");
                fileName = location[0];
                String imageName = null;
                try {
                    imageName = URLDecoder.decode(location[1].substring(1), "utf-8");
                    File file = new File(new URI(fileName));
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (JarFile jarFile = new JarFile(file);){
                        ZipEntry imageEntry = jarFile.getEntry(imageName);
                        if (imageEntry != null) {
                            streamHandler.handle(jarFile.getInputStream(imageEntry));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                }
                catch (IOException | URISyntaxException e) {
                    ImageUtil.throwCoreException("Error extracting " + this.url, e);
                }
            }
        }
    }

    private static abstract class UrlStreamProvider {
        protected URL url;

        private UrlStreamProvider() {
        }

        protected void setUrl(String sUrl) throws MalformedURLException {
            this.url = new URL(sUrl);
        }

        abstract void readStream(StreamHandler var1) throws CoreException;
    }
}

