/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.foundation.core.digest.DigestUtils;
import org.jboss.tools.foundation.core.ecf.URLTransportUtility;
import org.jboss.tools.foundation.core.properties.PropertiesHelper;
import org.jboss.tools.project.examples.internal.UnArchiver;
import org.osgi.framework.Bundle;

public class CentralHelper {
    public static final String JBOSS_CENTRAL_WEBPAGE_URL_KEY = "jboss.central.webpage.url";
    private static final String LATEST_WEBPAGE_URL = "https://repository.jboss.org/nexus/service/local/artifact/maven/redirect?r=public-jboss&g=org.jboss.tools.central&a=jbosstools-central-webpage&v=0.0.1-SNAPSHOT&e=zip&mustEndWith=.zip";

    private CentralHelper() {
    }

    public static String getCentralUrl(IProgressMonitor monitor) throws CoreException {
        String remoteUrl = CentralHelper.getCentralUrlPropertyValue();
        return CentralHelper.getCentralPageUrl(remoteUrl, "index.html", monitor);
    }

    private static String getCentralUrlPropertyValue() {
        String remoteUrl = System.getProperty(JBOSS_CENTRAL_WEBPAGE_URL_KEY);
        if (remoteUrl == null) {
            remoteUrl = PropertiesHelper.getPropertiesProvider().getValue(JBOSS_CENTRAL_WEBPAGE_URL_KEY, LATEST_WEBPAGE_URL);
        }
        return remoteUrl;
    }

    public static String getCentralUrl(String remoteUrl, IProgressMonitor monitor) throws CoreException {
        return CentralHelper.getCentralPageUrl(remoteUrl, "index.html", monitor);
    }

    private static String getCentralPageUrl(String remoteUrl, String page, IProgressMonitor monitor) throws CoreException {
        StringBuilder url = new StringBuilder();
        if (remoteUrl.endsWith(".zip")) {
            URI uri = null;
            java.nio.file.Path zip = null;
            try {
                uri = new URI(remoteUrl);
            }
            catch (URISyntaxException uRISyntaxException) {
                JBossCentralActivator.logWarning("Central page URL (" + remoteUrl + ") is invalid. Falling back to embedded version");
                zip = CentralHelper.getEmbeddedCentralZipPath();
            }
            if (uri != null) {
                zip = uri.getScheme() == null ? Paths.get(remoteUrl, new String[0]).toAbsolutePath() : ("file".equals(uri.getScheme()) ? Paths.get(uri).toAbsolutePath() : CentralHelper.downloadIfNeeded(uri, monitor));
            }
            java.nio.file.Path centralFolder = CentralHelper.getCentralFolder();
            java.nio.file.Path localCentralPage = null;
            try {
                if (zip != null) {
                    try {
                        localCentralPage = CentralHelper.extractIfNeeded(zip, centralFolder, false, monitor);
                    }
                    catch (Exception e) {
                        JBossCentralActivator.log(e, "An Error occured while extracting " + zip);
                    }
                }
                if (localCentralPage == null) {
                    zip = CentralHelper.getEmbeddedCentralZipPath();
                    if (!Files.exists(zip, new LinkOption[0])) {
                        throw new IOException("Can't find embedded central zip");
                    }
                    localCentralPage = CentralHelper.extractIfNeeded(zip, centralFolder, false, monitor);
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.jboss.tools.central", "Unable to open " + zip, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            url.append(localCentralPage);
        } else {
            url.append(remoteUrl);
        }
        String _url = url.toString();
        if (_url.endsWith(page)) {
            return _url;
        }
        if (_url.endsWith(".html")) {
            url = new StringBuilder(_url.substring(0, _url.lastIndexOf("/")));
        }
        if (!_url.endsWith("/")) {
            url.append("/");
        }
        url.append(page);
        return url.toString();
    }

    private static java.nio.file.Path getEmbeddedCentralZipPath() {
        return CentralHelper.getEmbeddedFilePath(JBossCentralActivator.getDefault().getBundle(), "resources/jbosstools-central-webpage.zip");
    }

    public static java.nio.file.Path getEmbeddedFilePath(Bundle bundle, String internalPath) {
        URL zip = FileLocator.find((Bundle)bundle, (IPath)new Path(internalPath), null);
        if (zip == null) {
            throw new IllegalArgumentException(String.valueOf(internalPath) + " is not a valid file path");
        }
        try {
            URL url = FileLocator.toFileURL((URL)zip);
            URI uri = new URI(url.toString().replace(" ", "%20"));
            return Paths.get(uri);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static java.nio.file.Path getCentralFolder() {
        IPath location = JBossCentralActivator.getDefault().getStateLocation();
        String path = location.append("central").toOSString();
        return Paths.get(path, new String[0]);
    }

    private static java.nio.file.Path downloadIfNeeded(URI uri, IProgressMonitor monitor) throws CoreException {
        int lifespan;
        String url = uri.toString();
        File zip = new URLTransportUtility().getCachedFileForURL(url, "Download central", lifespan = 1, monitor);
        if (zip != null && zip.exists()) {
            return zip.toPath();
        }
        return null;
    }

    private static java.nio.file.Path extractIfNeeded(java.nio.file.Path zip, java.nio.file.Path centralFolder, boolean overwrite, IProgressMonitor monitor) throws IOException {
        java.nio.file.Path extractedFile;
        boolean extracted;
        String sha1 = DigestUtils.sha1((java.nio.file.Path)zip).substring(0, 7);
        java.nio.file.Path destinationFolder = centralFolder.resolve(sha1);
        if (overwrite) {
            FileUtils.deleteDirectory((File)destinationFolder.toFile());
        }
        if (!(extracted = Files.isDirectory(destinationFolder, new LinkOption[0]))) {
            UnArchiver unarchiver = UnArchiver.create((File)zip.toFile(), (File)destinationFolder.toFile());
            unarchiver.extract(monitor);
        }
        if (!Files.isRegularFile(extractedFile = destinationFolder.resolve("index.html"), new LinkOption[0])) {
            if (extracted && !overwrite) {
                CentralHelper.extractIfNeeded(zip, centralFolder, true, monitor);
            } else {
                throw new IOException(extractedFile + " can not be found");
            }
        }
        return extractedFile;
    }

    public static String getLoadingPageUrl() {
        java.nio.file.Path loadingPage = CentralHelper.getLoadingPage();
        try {
            if (!Files.exists(loadingPage, new LinkOption[0]) || loadingPage.getFileName().toString().contains(".qualifier")) {
                String packageFolder = CentralHelper.class.getPackage().getName().replace('.', '/');
                URL scriptUrl = new URL("platform:/plugin/org.jboss.tools.central/" + packageFolder + "/loading.html");
                URL sourceUrl = FileLocator.resolve((URL)scriptUrl);
                FileUtils.copyURLToFile((URL)sourceUrl, (File)loadingPage.toFile());
            }
        }
        catch (IOException e) {
            JBossCentralActivator.log(e, "Unable to extract loading.html");
            return null;
        }
        return loadingPage.toUri().toString();
    }

    public static java.nio.file.Path getLoadingPage() {
        java.nio.file.Path centralFolder = CentralHelper.getCentralFolder();
        java.nio.file.Path loadingPage = centralFolder.resolve("loading_" + JBossCentralActivator.getVersion() + ".html");
        return loadingPage;
    }

    public static boolean isShowOnStartup() {
        IEclipsePreferences preferences = JBossCentralActivator.getDefault().getPreferences();
        return preferences.getBoolean("showJBossCentralOnStartup", true);
    }

    public static void setShowOnStartup(boolean value) {
        IEclipsePreferences preferences = JBossCentralActivator.getDefault().getPreferences();
        preferences.putBoolean("showJBossCentralOnStartup", value);
        JBossCentralActivator.getDefault().savePreferences();
    }
}

