/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal.offline;

import java.io.File;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.jboss.tools.project.examples.offline.OfflineUtil;

public class ExtractScriptJob
extends Job {
    public ExtractScriptJob() {
        super("Extract go_offline script");
        this.setRule(new ExtractScriptJobRule());
    }

    protected IStatus run(IProgressMonitor monitor) {
        File offlineScript = OfflineUtil.getGoOfflineScript();
        File grapeConfigXml = OfflineUtil.getGrapeConfigXml();
        boolean devMode = offlineScript.getName().contains(".qualifier");
        URL sourceUrl = null;
        String base = "platform:/plugin/org.jboss.tools.project.examples/offline/";
        if (devMode || !offlineScript.exists()) {
            try {
                URL scriptUrl = new URL(String.valueOf(base) + "go_offline.groovy");
                sourceUrl = FileLocator.resolve((URL)scriptUrl);
                FileUtils.copyURLToFile((URL)sourceUrl, (File)offlineScript);
            }
            catch (Exception e) {
                Status error = new Status(4, "org.jboss.tools.project.examples", "Impossible to copy the go_offline script", (Throwable)e);
                return error;
            }
        }
        if (devMode || !grapeConfigXml.exists()) {
            try {
                URL grapeConfigUrl = new URL(String.valueOf(base) + "jbossToolsGrapeConfig.xml");
                sourceUrl = FileLocator.resolve((URL)grapeConfigUrl);
                FileUtils.copyURLToFile((URL)sourceUrl, (File)grapeConfigXml);
            }
            catch (Exception e) {
                Status error = new Status(4, "org.jboss.tools.project.examples", "Impossible to copy jbossToolsGrapeConfig.xml", (Throwable)e);
                return error;
            }
        }
        return Status.OK_STATUS;
    }

    public static class ExtractScriptJobRule
    implements ISchedulingRule {
        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

